/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.internal.swt.controls;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.ECPControlDescription;
import org.eclipse.emf.ecp.edit.ECPControlFactory;
import org.eclipse.emf.ecp.edit.internal.swt.Activator;
import org.eclipse.emf.ecp.edit.util.ECPApplicableTester;
import org.eclipse.emf.ecp.edit.util.ECPStaticApplicableTester;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;

public class ReferenceMultiControlTester
implements ECPApplicableTester {
    public int isApplicable(IItemPropertyDescriptor itemPropertyDescriptor, EObject eObject) {
        int bestPriority = -1;
        ECPControlFactory controlFactory = Activator.getDefault().getECPControlFactory();
        if (controlFactory == null) {
            Activator.getDefault().ungetECPControlFactory();
            return bestPriority;
        }
        for (ECPControlDescription description : controlFactory.getControlDescriptors()) {
            for (ECPApplicableTester tester : description.getTester()) {
                ECPStaticApplicableTester test;
                int priority;
                if (!ECPStaticApplicableTester.class.isInstance(tester) || bestPriority >= (priority = ReferenceMultiControlTester.getTesterPriority(test = (ECPStaticApplicableTester)tester, itemPropertyDescriptor, eObject))) continue;
                bestPriority = priority;
            }
        }
        Activator.getDefault().ungetECPControlFactory();
        return bestPriority;
    }

    public static int getTesterPriority(ECPStaticApplicableTester tester, IItemPropertyDescriptor itemPropertyDescriptor, EObject eObject) {
        if (!itemPropertyDescriptor.isMany((Object)eObject)) {
            return -1;
        }
        EStructuralFeature feature = (EStructuralFeature)itemPropertyDescriptor.getFeature((Object)eObject);
        if (EAttribute.class.isInstance(feature)) {
            return -1;
        }
        if (EReference.class.isInstance(feature)) {
            Class instanceClass = feature.getEType().getInstanceClass();
            if (!tester.getSupportedClassType().isAssignableFrom(instanceClass)) {
                return -1;
            }
        }
        if (!tester.isSingleValue()) {
            return -1;
        }
        if (tester.getSupportedEObject().isInstance(eObject) && (tester.getSupportedFeature() == null || feature.equals(eObject.eClass().getEStructuralFeature(tester.getSupportedFeature())))) {
            return tester.getPriority() + 1;
        }
        return -1;
    }
}

