/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.internal.swt.controls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.EObjectObservableMap;
import org.eclipse.emf.databinding.edit.EMFEditObservables;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.ECPControlContext;
import org.eclipse.emf.ecp.edit.internal.swt.Activator;
import org.eclipse.emf.ecp.edit.internal.swt.table.TableColumnConfiguration;
import org.eclipse.emf.ecp.edit.internal.swt.table.TableControlConfiguration;
import org.eclipse.emf.ecp.edit.internal.swt.util.CellEditorFactory;
import org.eclipse.emf.ecp.edit.internal.swt.util.ECPCellEditor;
import org.eclipse.emf.ecp.edit.internal.swt.util.ECPDialogExecutor;
import org.eclipse.emf.ecp.edit.internal.swt.util.SWTControl;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapCellLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationListener;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerEditorDeactivationEvent;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class TableControl
extends SWTControl {
    private TableViewer tableViewer;
    private ComposedAdapterFactory composedAdapterFactory;
    private AdapterFactoryItemDelegator adapterFactoryItemDelegator;
    private Button unsetButton;
    private EClass clazz;
    private TableControlConfiguration tableControlConfiguration;
    private Map<EObject, Map<EStructuralFeature, Diagnostic>> featureErrorMap = new HashMap<EObject, Map<EStructuralFeature, Diagnostic>>();
    private Button removeButton;
    private Button addButton;

    public TableControl(boolean showLabel, IItemPropertyDescriptor itemPropertyDescriptor, EStructuralFeature feature, ECPControlContext modelElementContext, boolean embedded) {
        super(showLabel, itemPropertyDescriptor, feature, modelElementContext, embedded);
    }

    public TableControl(boolean showLabel, IItemPropertyDescriptor itemPropertyDescriptor, EStructuralFeature feature, ECPControlContext modelElementContext, boolean embedded, TableControlConfiguration tableControlConfiguration) {
        super(showLabel, itemPropertyDescriptor, feature, modelElementContext, embedded);
        this.tableControlConfiguration = tableControlConfiguration;
    }

    protected Binding bindValue() {
        return null;
    }

    public Composite createControl(Composite parent) {
        this.composedAdapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        this.adapterFactoryItemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)this.composedAdapterFactory);
        this.clazz = ((EReference)this.getStructuralFeature()).getEReferenceType();
        Composite titleComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).align(4, 1).applyTo((Control)titleComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).applyTo(titleComposite);
        Label label = new Label(titleComposite, 0);
        label.setText(this.getItemPropertyDescriptor().getDisplayName(null));
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)label);
        this.validationLabel = new Label(titleComposite, 0);
        GridDataFactory.fillDefaults().hint(16, 17).applyTo((Control)this.validationLabel);
        boolean createButtons = true;
        if (this.tableControlConfiguration != null) {
            boolean bl = createButtons = !this.tableControlConfiguration.isAddRemoveDisabled();
        }
        if (createButtons) {
            Composite buttonComposite = new Composite(titleComposite, 0);
            GridDataFactory.fillDefaults().align(0x1000008, 1).grab(true, false).applyTo((Control)buttonComposite);
            int numButtons = 2;
            this.createAddRowButton(this.clazz, buttonComposite);
            this.createRemoveRowButton(this.clazz, buttonComposite);
            if (!this.isEmbedded() && this.getStructuralFeature().isUnsettable()) {
                this.unsetButton = new Button(buttonComposite, 8);
                this.unsetButton.setToolTipText(this.getUnsetButtonTooltip());
                this.unsetButton.setImage(Activator.getImage("icons/delete.png"));
                ++numButtons;
            }
            GridLayoutFactory.fillDefaults().numColumns(numButtons).equalWidth(true).applyTo(buttonComposite);
        }
        Composite controlComposite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).align(4, 4).applyTo((Control)controlComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(controlComposite);
        this.createContentControl(controlComposite);
        return parent;
    }

    protected void fillControlComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).hint(1, 200).applyTo((Control)composite);
        this.tableViewer = new TableViewer(composite, 68098);
        this.tableViewer.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_table");
        this.tableViewer.getTable().setHeaderVisible(true);
        this.tableViewer.getTable().setLinesVisible(true);
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(this.tableViewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.tableViewer));
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.tableViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 2 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)this.tableViewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
        ObservableListContentProvider cp = new ObservableListContentProvider();
        EObject tempInstance = this.clazz.getEPackage().getEFactoryInstance().create(this.clazz);
        ECPTableViewerComparator comparator = new ECPTableViewerComparator();
        this.tableViewer.setComparator((ViewerComparator)comparator);
        int columnNumber = 0;
        Object structuralFeatures = this.clazz.getEAllStructuralFeatures();
        HashMap<EAttribute, Boolean> readOnlyColumn = null;
        if (this.tableControlConfiguration != null) {
            structuralFeatures = new ArrayList();
            readOnlyColumn = new HashMap<EAttribute, Boolean>();
            for (TableColumnConfiguration tcc : this.tableControlConfiguration.getColumns()) {
                structuralFeatures.add(tcc.getColumnAttribute());
                readOnlyColumn.put(tcc.getColumnAttribute(), tcc.isReadOnly());
            }
        }
        Iterator<Object> iterator = structuralFeatures.iterator();
        while (iterator.hasNext()) {
            final EStructuralFeature feature = (EStructuralFeature)iterator.next();
            IItemPropertyDescriptor itemPropertyDescriptor = this.adapterFactoryItemDelegator.getPropertyDescriptor((Object)tempInstance, (Object)feature);
            if (itemPropertyDescriptor == null) continue;
            final CellEditor cellEditor = CellEditorFactory.INSTANCE.getCellEditor(itemPropertyDescriptor, tempInstance, this.tableViewer.getTable(), this.getModelElementContext());
            TableViewerColumn column = new TableViewerColumn(this.tableViewer, cellEditor.getStyle());
            if (ECPCellEditor.class.isInstance(cellEditor)) {
                column.getColumn().setData("width", (Object)((ECPCellEditor)cellEditor).getColumnWidthWeight());
            } else {
                column.getColumn().setData("width", (Object)100);
            }
            Object map = null;
            map = feature.isMany() ? new EObjectObservableMap(cp.getKnownElements(), feature) : EMFProperties.value((EStructuralFeature)feature).observeDetail(cp.getKnownElements());
            column.setLabelProvider((CellLabelProvider)new ObservableMapCellLabelProvider((IObservableMap)map){

                public void update(ViewerCell cell) {
                    EObject element = (EObject)cell.getElement();
                    Object value = this.attributeMaps[0].get((Object)element);
                    if (ECPCellEditor.class.isInstance(cellEditor)) {
                        ECPCellEditor ecpCellEditor = (ECPCellEditor)cellEditor;
                        String text = ecpCellEditor.getFormatedString(value);
                        cell.setText(text == null ? "" : text);
                    } else {
                        cell.setText(value == null ? "" : value.toString());
                        cell.getControl().setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_edit_cellEditor_string");
                    }
                    if (TableControl.this.featureErrorMap.containsKey(element) && ((Map)TableControl.this.featureErrorMap.get(element)).containsKey(this.attributeMaps[0].getValueType())) {
                        cell.setBackground(Display.getDefault().getSystemColor(3));
                    } else {
                        cell.setBackground(null);
                    }
                }
            });
            column.getColumn().addSelectionListener((SelectionListener)this.getSelectionAdapter(comparator, column.getColumn(), columnNumber));
            column.getColumn().setText(itemPropertyDescriptor.getDisplayName(null));
            column.getColumn().setToolTipText(itemPropertyDescriptor.getDescription(null));
            column.getColumn().setResizable(true);
            column.getColumn().setMoveable(false);
            boolean addEditingSupport = true;
            if (readOnlyColumn != null) {
                boolean bl = addEditingSupport = (Boolean)readOnlyColumn.get(feature) == false;
            }
            if (addEditingSupport) {
                EditingSupport observableSupport = new EditingSupport((ColumnViewer)this.tableViewer){
                    private EditingState editingState;
                    private final ColumnViewerEditorActivationListenerHelper activationListener;
                    {
                        super($anonymous0);
                        this.activationListener = new ColumnViewerEditorActivationListenerHelper();
                    }

                    protected boolean canEdit(Object element) {
                        return true;
                    }

                    protected Object getValue(Object element) {
                        return null;
                    }

                    protected void setValue(Object element, Object value) {
                    }

                    protected void initializeCellEditorValue(CellEditor cellEditor2, ViewerCell cell) {
                        IObservableValue target = this.doCreateCellEditorObservable(cellEditor2);
                        Assert.isNotNull((Object)target, (String)"doCreateCellEditorObservable(...) did not return an observable");
                        IObservableValue model = this.doCreateElementObservable(cell.getElement(), cell);
                        Assert.isNotNull((Object)model, (String)"doCreateElementObservable(...) did not return an observable");
                        Binding binding = this.createBinding(target, model);
                        Assert.isNotNull((Object)binding, (String)"createBinding(...) did not return a binding");
                        this.editingState = new EditingState(binding, target, model);
                        this.getViewer().getColumnViewerEditor().addEditorActivationListener((ColumnViewerEditorActivationListener)this.activationListener);
                    }

                    protected CellEditor getCellEditor(Object element) {
                        return cellEditor;
                    }

                    protected Binding createBinding(IObservableValue target, IObservableValue model) {
                        if (ECPCellEditor.class.isInstance(cellEditor)) {
                            return TableControl.this.getDataBindingContext().bindValue(target, model, ((ECPCellEditor)cellEditor).getTargetToModelStrategy(), ((ECPCellEditor)cellEditor).getModelToTargetStrategy());
                        }
                        return TableControl.this.getDataBindingContext().bindValue(target, model);
                    }

                    protected IObservableValue doCreateElementObservable(Object element, ViewerCell cell) {
                        return EMFEditObservables.observeValue((EditingDomain)TableControl.this.getModelElementContext().getEditingDomain(), (EObject)((EObject)element), (EStructuralFeature)feature);
                    }

                    protected IObservableValue doCreateCellEditorObservable(CellEditor cellEditor2) {
                        if (ECPCellEditor.class.isInstance(cellEditor2)) {
                            return ((ECPCellEditor)cellEditor2).getValueProperty().observe((Object)cellEditor2);
                        }
                        return SWTObservables.observeText((Control)cellEditor2.getControl(), (int)16);
                    }

                    protected final void saveCellEditorValue(CellEditor cellEditor2, ViewerCell cell) {
                        this.editingState.binding.updateTargetToModel();
                    }

                    class ColumnViewerEditorActivationListenerHelper
                    extends ColumnViewerEditorActivationListener {
                        ColumnViewerEditorActivationListenerHelper() {
                        }

                        public void afterEditorActivated(ColumnViewerEditorActivationEvent event) {
                        }

                        public void afterEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
                            editingState.dispose();
                            editingState = null;
                            this.getViewer().getColumnViewerEditor().removeEditorActivationListener((ColumnViewerEditorActivationListener)this);
                        }

                        public void beforeEditorActivated(ColumnViewerEditorActivationEvent event) {
                        }

                        public void beforeEditorDeactivated(ColumnViewerEditorDeactivationEvent event) {
                        }
                    }

                    class EditingState {
                        IObservableValue target;
                        IObservableValue model;
                        Binding binding;

                        EditingState(Binding binding, IObservableValue target, IObservableValue model) {
                            this.binding = binding;
                            this.target = target;
                            this.model = model;
                        }

                        void dispose() {
                            this.binding.dispose();
                            this.target.dispose();
                            this.model.dispose();
                        }
                    }
                };
                column.setEditingSupport(observableSupport);
            }
            ++columnNumber;
        }
        this.tableViewer.setContentProvider((IContentProvider)cp);
        IObservableList list = EMFEditObservables.observeList((EditingDomain)this.getModelElementContext().getEditingDomain(), (EObject)this.getModelElementContext().getModelElement(), (EStructuralFeature)this.getStructuralFeature());
        this.tableViewer.setInput((Object)list);
        TableColumnLayout layout = new TableColumnLayout();
        composite.setLayout((Layout)layout);
        int i = 0;
        while (i < this.tableViewer.getTable().getColumns().length) {
            Integer storedValue = (Integer)this.tableViewer.getTable().getColumns()[i].getData("width");
            layout.setColumnData((Widget)this.tableViewer.getTable().getColumns()[i], (ColumnLayoutData)new ColumnWeightData(storedValue == null ? 50 : storedValue));
            ++i;
        }
    }

    protected Button getCustomUnsetButton() {
        return this.unsetButton;
    }

    private SelectionAdapter getSelectionAdapter(final ECPTableViewerComparator comparator, final TableColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                comparator.setColumn(index);
                int dir = comparator.getDirection();
                TableControl.this.tableViewer.getTable().setSortDirection(dir);
                TableControl.this.tableViewer.getTable().setSortColumn(column);
                TableControl.this.tableViewer.refresh();
            }
        };
        return selectionAdapter;
    }

    private void createRemoveRowButton(EClass clazz, Composite buttonComposite) {
        this.removeButton = new Button(buttonComposite, 0);
        Image image = Activator.getImage("icons/delete.png");
        this.removeButton.setImage(image);
        this.removeButton.setToolTipText("Remove the selected " + clazz.getInstanceClass().getSimpleName());
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)TableControl.this.tableViewer.getSelection();
                if (selection == null || selection.getFirstElement() == null) {
                    return;
                }
                final ArrayList<EObject> deletionList = new ArrayList<EObject>();
                Iterator iterator = selection.iterator();
                while (iterator.hasNext()) {
                    deletionList.add((EObject)iterator.next());
                }
                MessageDialog dialog = new MessageDialog(TableControl.this.tableViewer.getTable().getShell(), "Delete?", null, "Are you sure you want to delete the selected Elements?", 5, new String[]{JFaceResources.getString((String)"yes"), JFaceResources.getString((String)"no")}, 0);
                final EObject modelElement = TableControl.this.getModelElementContext().getModelElement();
                new ECPDialogExecutor((Dialog)dialog){

                    public void handleResult(int codeResult) {
                        if (codeResult == 1) {
                            return;
                        }
                        EditingDomain editingDomain = TableControl.this.getModelElementContext().getEditingDomain();
                        editingDomain.getCommandStack().execute(RemoveCommand.create((EditingDomain)editingDomain, (Object)modelElement, (Object)TableControl.this.getStructuralFeature(), (Collection)deletionList));
                    }
                }.execute();
                List containments = (List)modelElement.eGet(TableControl.this.getStructuralFeature());
                if (containments.size() < TableControl.this.getStructuralFeature().getUpperBound()) {
                    TableControl.this.addButton.setEnabled(true);
                }
                if (containments.size() <= TableControl.this.getStructuralFeature().getLowerBound()) {
                    TableControl.this.removeButton.setEnabled(false);
                }
            }
        });
        EObject modelElement = this.getModelElementContext().getModelElement();
        List containments = (List)modelElement.eGet(this.getStructuralFeature());
        if (containments.size() <= this.getStructuralFeature().getLowerBound()) {
            this.removeButton.setEnabled(false);
        }
    }

    private void createAddRowButton(final EClass clazz, Composite buttonComposite) {
        this.addButton = new Button(buttonComposite, 0);
        Image image = Activator.getImage("icons/add.png");
        this.addButton.setImage(image);
        this.addButton.setToolTipText("Add an instance of " + clazz.getInstanceClass().getSimpleName());
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableControl.this.addRow(clazz);
                EObject modelElement = TableControl.this.getModelElementContext().getModelElement();
                List containments = (List)modelElement.eGet(TableControl.this.getStructuralFeature());
                if (TableControl.this.getStructuralFeature().getUpperBound() != -1 && containments.size() == TableControl.this.getStructuralFeature().getUpperBound()) {
                    TableControl.this.addButton.setEnabled(false);
                }
                if (containments.size() > TableControl.this.getStructuralFeature().getLowerBound()) {
                    TableControl.this.removeButton.setEnabled(true);
                }
            }
        });
        EObject modelElement = this.getModelElementContext().getModelElement();
        List containments = (List)modelElement.eGet(this.getStructuralFeature());
        if (this.getStructuralFeature().getUpperBound() != -1 && containments.size() >= this.getStructuralFeature().getUpperBound()) {
            this.addButton.setEnabled(false);
        }
    }

    public void dispose() {
        this.composedAdapterFactory.dispose();
    }

    public void handleValidation(Diagnostic diagnostic) {
        if (diagnostic.getSeverity() == 4 || diagnostic.getSeverity() == 2) {
            Image image = Activator.getImage("icons/validation_error.png");
            this.validationLabel.setImage(image);
            this.validationLabel.setToolTipText(diagnostic.getMessage());
            EObject object = (EObject)diagnostic.getData().get(0);
            if (!this.featureErrorMap.containsKey(object)) {
                this.featureErrorMap.put(object, new HashMap());
            }
            if (diagnostic.getData().size() > 1) {
                this.featureErrorMap.get(object).put((EStructuralFeature)diagnostic.getData().get(1), diagnostic);
            }
            this.tableViewer.update((Object)object, null);
        }
    }

    public void resetValidation() {
        this.featureErrorMap.clear();
        if (this.validationLabel == null || this.validationLabel.isDisposed()) {
            return;
        }
        this.validationLabel.setImage(null);
    }

    public void setEditable(boolean isEditable) {
        this.tableViewer.getTable().setEnabled(false);
    }

    private void addRow(EClass clazz) {
        EObject modelElement = this.getModelElementContext().getModelElement();
        EObject instance = clazz.getEPackage().getEFactoryInstance().create(clazz);
        EditingDomain editingDomain = this.getModelElementContext().getEditingDomain();
        editingDomain.getCommandStack().execute(AddCommand.create((EditingDomain)editingDomain, (Object)modelElement, (Object)this.getStructuralFeature(), (Object)instance));
    }

    protected String getUnsetLabelText() {
        return "Not set. Click to set!";
    }

    protected String getUnsetButtonTooltip() {
        return "Unset";
    }

    protected Control[] getControlsForTooltip() {
        return new Control[]{this.tableViewer.getControl()};
    }

    private class ECPTableViewerComparator
    extends ViewerComparator {
        private int propertyIndex = 0;
        private static final int NONE = 0;
        private int direction = 0;

        public int getDirection() {
            switch (this.direction) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 128;
                }
                case 2: {
                    return 1024;
                }
            }
            return 0;
        }

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = (this.direction + 1) % 3;
            } else {
                this.propertyIndex = column;
                this.direction = 1;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (this.direction == 0) {
                return 0;
            }
            int rc = 0;
            EObject object1 = (EObject)e1;
            EObject object2 = (EObject)e2;
            EStructuralFeature feat1 = (EStructuralFeature)object1.eClass().getEAllStructuralFeatures().get(this.propertyIndex);
            EStructuralFeature feat2 = (EStructuralFeature)object2.eClass().getEAllStructuralFeatures().get(this.propertyIndex);
            Object value1 = object1.eGet(feat1);
            Object value2 = object2.eGet(feat2);
            rc = value1 == null ? 1 : (value2 == null ? -1 : value1.toString().compareTo(value2.toString()));
            if (this.direction == 2) {
                rc = -rc;
            }
            return rc;
        }
    }
}

