/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.internal.swt.table;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.ECPControlContext;
import org.eclipse.emf.ecp.edit.internal.swt.Activator;
import org.eclipse.emf.ecp.edit.internal.swt.controls.NumericalHelper;
import org.eclipse.emf.ecp.edit.internal.swt.util.ECPCellEditor;
import org.eclipse.emf.ecp.edit.internal.swt.util.ECPDialogExecutor;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.CellEditorProperties;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberCellEditor
extends TextCellEditor
implements ECPCellEditor {
    private IItemPropertyDescriptor descriptor;
    private ECPControlContext ecpControlContext;

    public NumberCellEditor(Composite parent) {
        super(parent, 131072);
    }

    public NumberCellEditor(Composite parent, int style) {
        super(parent, style | 0x20000);
    }

    @Override
    public IValueProperty getValueProperty() {
        return CellEditorProperties.control().value((IValueProperty)WidgetProperties.text((int)16));
    }

    @Override
    public void instantiate(IItemPropertyDescriptor descriptor, ECPControlContext ecpControlContext) {
        this.descriptor = descriptor;
        this.ecpControlContext = ecpControlContext;
        this.getControl().setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_edit_cellEditor_numberical");
    }

    @Override
    public String getFormatedString(Object value) {
        if (value == null) {
            this.setErrorMessage("Value is null");
            return "";
        }
        DecimalFormat format = NumericalHelper.setupFormat(this.ecpControlContext.getLocale(), this.getInstanceClass());
        return format.format(value);
    }

    @Override
    public int getColumnWidthWeight() {
        return 50;
    }

    @Override
    public UpdateValueStrategy getTargetToModelStrategy() {
        return new EMFUpdateValueStrategy(){

            public Object convert(Object value) {
                String formatedNumber;
                DecimalFormat format;
                block18: {
                    format = NumericalHelper.setupFormat(NumberCellEditor.this.ecpControlContext.getLocale(), NumberCellEditor.this.getInstanceClass());
                    try {
                        Number number = null;
                        if (value == null) {
                            number = NumericalHelper.getDefaultValue(NumberCellEditor.this.getInstanceClass());
                        } else {
                            ParsePosition pp = new ParsePosition(0);
                            number = format.parse((String)value, pp);
                            if (pp.getErrorIndex() != -1 || pp.getIndex() != ((String)value).length()) {
                                return this.revertToOldValue(value);
                            }
                            if (NumericalHelper.isInteger(NumberCellEditor.this.getInstanceClass())) {
                                boolean maxValue = false;
                                Class instanceClass = NumberCellEditor.this.getInstanceClass();
                                String formatedValue = "";
                                try {
                                    if (Integer.class.isAssignableFrom(instanceClass) || Integer.class.getField("TYPE").get(null).equals(instanceClass)) {
                                        if (Integer.MAX_VALUE == number.intValue()) {
                                            maxValue = true;
                                            formatedValue = format.format(Integer.MAX_VALUE);
                                        }
                                    } else if ((Long.class.isAssignableFrom(instanceClass) || Long.class.getField("TYPE").get(null).equals(instanceClass)) && Long.MAX_VALUE == number.longValue()) {
                                        maxValue = true;
                                        formatedValue = format.format(Long.MAX_VALUE);
                                    }
                                }
                                catch (IllegalArgumentException ex) {
                                    Activator.logException(ex);
                                }
                                catch (SecurityException ex) {
                                    Activator.logException(ex);
                                }
                                catch (IllegalAccessException ex) {
                                    Activator.logException(ex);
                                }
                                catch (NoSuchFieldException ex) {
                                    Activator.logException(ex);
                                }
                                if (maxValue) {
                                    NumberCellEditor.this.getText().setText(formatedValue);
                                    return NumericalHelper.numberToInstanceClass(number, NumberCellEditor.this.getInstanceClass());
                                }
                            }
                        }
                        formatedNumber = "";
                        if (number != null) {
                            formatedNumber = format.format(number);
                        }
                        NumberCellEditor.this.getText().setText(formatedNumber);
                        if (formatedNumber.length() != 0) break block18;
                        return null;
                    }
                    catch (ParseException parseException) {
                        return this.revertToOldValue(value);
                    }
                }
                return NumericalHelper.numberToInstanceClass(format.parse(formatedNumber), NumberCellEditor.this.getInstanceClass());
            }

            private Object revertToOldValue(Object value) {
                if (NumberCellEditor.this.getStructuralFeature().getDefaultValue() == null && (value == null || value.equals(""))) {
                    return null;
                }
                Object result = null;
                MessageDialog messageDialog = new MessageDialog(NumberCellEditor.this.getText().getShell(), "Invalid Number", null, "The Number you have entered is invalid. The value will be unset.", 1, new String[]{JFaceResources.getString((String)"ok")}, 0);
                new ECPDialogExecutor((Dialog)messageDialog){

                    public void handleResult(int codeResult) {
                    }
                }.execute();
                if (result == null) {
                    NumberCellEditor.this.getText().setText("");
                } else {
                    DecimalFormat format = NumericalHelper.setupFormat(NumberCellEditor.this.ecpControlContext.getLocale(), NumberCellEditor.this.getInstanceClass());
                    NumberCellEditor.this.getText().setText(format.format(result));
                }
                return result;
            }
        };
    }

    @Override
    public UpdateValueStrategy getModelToTargetStrategy() {
        return new EMFUpdateValueStrategy(){

            public Object convert(Object value) {
                if (value == null) {
                    return "";
                }
                DecimalFormat format = NumericalHelper.setupFormat(NumberCellEditor.this.ecpControlContext.getLocale(), NumberCellEditor.this.getInstanceClass());
                return format.format(value);
            }
        };
    }

    private Class<?> getInstanceClass() {
        return this.getStructuralFeature().getEType().getInstanceClass();
    }

    private Text getText() {
        return this.text;
    }

    private EStructuralFeature getStructuralFeature() {
        return (EStructuralFeature)this.descriptor.getFeature(null);
    }
}

