/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.internal.swt.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.edit.ECPControlContext;
import org.eclipse.emf.ecp.edit.internal.swt.Activator;
import org.eclipse.emf.ecp.edit.internal.swt.util.ECPCellEditor;
import org.eclipse.emf.ecp.edit.util.ECPApplicableTester;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CellEditorFactory {
    private static final String CONTROL_EXTENSION = "org.eclipse.emf.ecp.edit.swt.cellEditor";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String ID = "id";
    private static final String TESTER = "tester";
    private Set<CellDescriptor> descriptors = new HashSet<CellDescriptor>();
    public static final CellEditorFactory INSTANCE = new CellEditorFactory();

    private CellEditorFactory() {
        this.parseExtensionPoint();
    }

    private void parseExtensionPoint() {
        IConfigurationElement[] controls;
        IConfigurationElement[] iConfigurationElementArray = controls = Platform.getExtensionRegistry().getConfigurationElementsFor(CONTROL_EXTENSION);
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                String id = e.getAttribute(ID);
                String clazz = e.getAttribute(CLASS_ATTRIBUTE);
                Class resolvedClass = CellEditorFactory.loadClass(e.getContributor().getName(), clazz);
                ECPApplicableTester tester = (ECPApplicableTester)e.createExecutableExtension(TESTER);
                this.descriptors.add(new CellDescriptor(id, resolvedClass, tester));
            }
            catch (ClassNotFoundException e1) {
                Activator.logException(e1);
            }
            catch (CoreException e1) {
                Activator.logException((Exception)((Object)e1));
            }
            ++n2;
        }
    }

    private static <T> Class<T> loadClass(String bundleName, String clazz) throws ClassNotFoundException {
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            throw new ClassNotFoundException(String.valueOf(clazz) + " cannot be loaded because bundle " + bundleName + " cannot be resolved");
        }
        return bundle.loadClass(clazz);
    }

    public CellEditor getCellEditor(IItemPropertyDescriptor propertyDescriptor, EObject eObject, Table table, ECPControlContext ecpControlContext) {
        int bestPriority = -1;
        CellDescriptor bestCandidate = null;
        for (CellDescriptor descriptor : this.descriptors) {
            int priority = descriptor.getTester().isApplicable(propertyDescriptor, eObject);
            if (priority <= bestPriority) continue;
            bestCandidate = descriptor;
            bestPriority = priority;
        }
        TextCellEditor result = null;
        if (bestCandidate != null) {
            try {
                Constructor<? extends CellEditor> constructor = bestCandidate.getCellEditorClass().getConstructor(Composite.class);
                result = constructor.newInstance(table);
                ECPCellEditor ecpCellEditor = (ECPCellEditor)result;
                ecpCellEditor.instantiate(propertyDescriptor, ecpControlContext);
            }
            catch (SecurityException e) {
                Activator.logException(e);
            }
            catch (NoSuchMethodException e) {
                Activator.logException(e);
            }
            catch (IllegalArgumentException e) {
                Activator.logException(e);
            }
            catch (InstantiationException e) {
                Activator.logException(e);
            }
            catch (IllegalAccessException e) {
                Activator.logException(e);
            }
            catch (InvocationTargetException e) {
                Activator.logException(e);
            }
            catch (ClassCastException e) {
                Activator.logException(e);
            }
        }
        if (result == null) {
            result = new TextCellEditor((Composite)table);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CellDescriptor {
        private final String id;
        private final Class<? extends CellEditor> cellEditorClass;
        private final ECPApplicableTester tester;

        CellDescriptor(String id, Class<? extends CellEditor> cellEditorClass, ECPApplicableTester tester) {
            this.id = id;
            this.cellEditorClass = cellEditorClass;
            this.tester = tester;
        }

        String getId() {
            return this.id;
        }

        Class<? extends CellEditor> getCellEditorClass() {
            return this.cellEditorClass;
        }

        ECPApplicableTester getTester() {
            return this.tester;
        }
    }
}

