/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.common.cachetree;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.common.cachetree.CachedTreeNode;
import org.eclipse.emf.ecp.common.cachetree.IExcludedObjectsCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCachedTree<T> {
    protected Map<Object, CachedTreeNode<T>> nodes = new LinkedHashMap<Object, CachedTreeNode<T>>();
    private CachedTreeNode<T> rootValue = this.createdCachedTreeNode(this.getDefaultValue());
    private IExcludedObjectsCallback excludedCallback;

    public AbstractCachedTree(IExcludedObjectsCallback callback) {
        this.excludedCallback = callback;
    }

    public abstract T getDefaultValue();

    protected abstract CachedTreeNode<T> createdCachedTreeNode(T var1);

    public Set<EObject> update(EObject eObject, T value) {
        if (this.excludedCallback.isExcluded(eObject)) {
            return Collections.emptySet();
        }
        this.updateNode(eObject, value);
        this.rootValue.putIntoCache(eObject, value);
        Set<EObject> affectedElements = this.removeOutdatedParentCacheIfNeeded(eObject);
        EObject parent = eObject.eContainer();
        while (parent != null && !this.excludedCallback.isExcluded(parent)) {
            this.updateParentNode(parent, eObject, this.nodes.get(eObject).getDisplayValue());
            eObject = parent;
            parent = parent.eContainer();
            affectedElements.add(eObject);
        }
        return affectedElements;
    }

    private Set<EObject> removeOutdatedParentCacheIfNeeded(EObject eObject) {
        HashSet<EObject> affectedElements = new HashSet<EObject>();
        CachedTreeNode<T> node = this.nodes.get(eObject);
        if (node.getParent() != null && node.getParent() != eObject.eContainer()) {
            EObject oldParent = (EObject)node.getParent();
            while (oldParent != null && !this.excludedCallback.isExcluded(oldParent)) {
                affectedElements.add(oldParent);
                node = this.nodes.get(oldParent);
                node.removeFromCache(eObject);
                eObject = oldParent = oldParent.eContainer();
            }
        }
        return affectedElements;
    }

    public T getRootValue() {
        return this.rootValue.getDisplayValue();
    }

    public T getCachedValue(Object eObject) {
        CachedTreeNode<T> nodeEntry = this.nodes.get(eObject);
        if (nodeEntry != null) {
            return this.nodes.get(eObject).getDisplayValue();
        }
        return this.getDefaultValue();
    }

    public void remove(EObject eObject) {
        CachedTreeNode<T> node = this.nodes.get(eObject);
        CachedTreeNode<T> parentNode = this.nodes.get(node.getParent());
        this.nodes.remove(eObject);
        this.rootValue.removeFromCache(eObject);
        if (parentNode == null) {
            return;
        }
        parentNode.removeFromCache(eObject);
        EObject parent = eObject.eContainer();
        while (parent != null && !this.excludedCallback.isExcluded(parent)) {
            node = this.nodes.get(parent);
            node.removeFromCache(eObject);
            eObject = parent = parent.eContainer();
        }
    }

    private void updateNode(Object object, T t) {
        CachedTreeNode<T> node = this.nodes.get(object);
        if (node == null) {
            node = this.createNodeEntry(object, t);
        }
        node.setOwnValue(t);
    }

    private CachedTreeNode<T> createNodeEntry(Object object, T t) {
        CachedTreeNode<T> node = this.createdCachedTreeNode(t);
        this.nodes.put(object, node);
        return node;
    }

    protected void updateParentNode(Object parent, Object object, T value) {
        CachedTreeNode<T> node = this.nodes.get(object);
        CachedTreeNode<T> parentNode = this.nodes.get(parent);
        node.setParent(parent);
        if (parentNode == null) {
            parentNode = this.createNodeEntry(parent, this.getDefaultValue());
        }
        parentNode.putIntoCache(object, value);
        this.rootValue.putIntoCache(parent, parentNode.getDisplayValue());
    }

    public void clear() {
        this.nodes.clear();
        this.rootValue = this.createdCachedTreeNode(this.getDefaultValue());
    }
}

