/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.workspace.internal.core;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.core.ECPRepository;
import org.eclipse.emf.ecp.core.util.ECPContainer;
import org.eclipse.emf.ecp.core.util.ECPModelContextAdapter;
import org.eclipse.emf.ecp.spi.core.DefaultProvider;
import org.eclipse.emf.ecp.spi.core.InternalProject;
import org.eclipse.emf.ecp.spi.core.InternalProvider;
import org.eclipse.emf.ecp.spi.core.util.InternalChildrenList;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceProvider
extends DefaultProvider {
    public static final String NAME = "org.eclipse.emf.ecp.workspace.provider";
    public static final String PROP_ROOT_URI = "rootURI";
    static WorkspaceProvider INSTANCE;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$emf$ecp$spi$core$InternalProvider$LifecycleEvent;

    public WorkspaceProvider() {
        super(NAME);
        INSTANCE = this;
    }

    public void handleLifecycle(ECPContainer context, InternalProvider.LifecycleEvent event) {
        switch (event) {
            case INIT: {
                this.handleInit(context);
                break;
            }
            case DISPOSE: {
                this.handelDispose(context);
                break;
            }
            case CREATE: {
                this.handleCreate(context);
                break;
            }
            case REMOVE: {
                this.handleRemove(context);
                break;
            }
        }
    }

    private void handleInit(ECPContainer context) {
        if (context instanceof InternalProject) {
            InternalProject project = (InternalProject)context;
            EditingDomain editingDomain = project.getEditingDomain();
            editingDomain.getResourceSet().eAdapters().add((Object)new WorkspaceProjectObserver(project));
        }
    }

    private void handleRemove(ECPContainer context) {
    }

    private void handleCreate(ECPContainer context) {
    }

    private void handelDispose(ECPContainer context) {
    }

    protected void doDispose() {
        try {
            super.doDispose();
        }
        finally {
            INSTANCE = null;
        }
    }

    public boolean hasCreateRepositorySupport() {
        return false;
    }

    public void fillChildren(ECPContainer context, Object parent, InternalChildrenList childrenList) {
        if (!(parent instanceof ECPRepository)) {
            if (parent instanceof ECPProject) {
                ECPProject project = (ECPProject)parent;
                String rootURI = project.getProperties().getValue(PROP_ROOT_URI);
                ResourceSet resourceSet = project.getEditingDomain().getResourceSet();
                URI uri = URI.createURI((String)rootURI);
                if (uri.hasFragment()) {
                    EObject eObject = resourceSet.getEObject(uri, true);
                    super.fillChildren(context, (Object)eObject, childrenList);
                } else {
                    Resource resource = resourceSet.getResource(uri, true);
                    childrenList.addChildren((Collection)resource.getContents());
                }
            } else {
                super.fillChildren(context, parent, childrenList);
            }
        }
    }

    public EList<? extends Object> getElements(InternalProject project) {
        ResourceSet resourceSet = project.getEditingDomain().getResourceSet();
        return ECollections.unmodifiableEList((EList)resourceSet.getResource(URI.createURI((String)project.getProperties().getValue(PROP_ROOT_URI)), true).getContents());
    }

    public boolean contains(InternalProject project, Object object) {
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            EObject root = EcoreUtil.getRootContainer((EObject)eObject);
            if (root == null || root.eResource() == null) {
                return false;
            }
            return root.eResource().equals(this.getRoot(project));
        }
        return false;
    }

    public void reload(InternalProject project) {
        EList resources = project.getEditingDomain().getResourceSet().getResources();
        for (Resource resource : resources) {
            if (!resource.equals(this.getRoot(project)) || !resource.isLoaded()) continue;
            resource.unload();
            try {
                resource.load(Collections.EMPTY_MAP);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void delete(InternalProject project, Collection<Object> objects) {
        project.getEditingDomain().getCommandStack().execute(DeleteCommand.create((EditingDomain)project.getEditingDomain(), objects));
    }

    public void cloneProject(InternalProject projectToClone, InternalProject targetProject) {
        throw new UnsupportedOperationException();
    }

    public Notifier getRoot(InternalProject project) {
        return project.getEditingDomain().getResourceSet().getResource(URI.createURI((String)project.getProperties().getValue(PROP_ROOT_URI)), true);
    }

    public void doSave(InternalProject project) {
        try {
            HashMap<String, String> saveOptions = new HashMap<String, String>();
            saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
            EList resources = project.getEditingDomain().getResourceSet().getResources();
            for (Resource resource : resources) {
                resource.save(saveOptions);
            }
            ((BasicCommandStack)project.getEditingDomain().getCommandStack()).saveIsDone();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        super.doSave(project);
    }

    public boolean isDirty(InternalProject project) {
        return ((BasicCommandStack)project.getEditingDomain().getCommandStack()).isSaveNeeded();
    }

    public EditingDomain createEditingDomain(InternalProject project) {
        BasicCommandStack commandStack = new BasicCommandStack();
        AdapterFactoryEditingDomain editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)InternalProvider.EMF_ADAPTER_FACTORY, (CommandStack)commandStack);
        editingDomain.getResourceSet().eAdapters().add((Object)new ECPModelContextAdapter((ECPContainer)project));
        URI uri = URI.createURI((String)project.getProperties().getValue(PROP_ROOT_URI));
        try {
            editingDomain.getResourceSet().getResource(uri, true);
        }
        catch (WrappedException wrappedException) {
            project.close();
        }
        return editingDomain;
    }

    public ECPContainer getModelContext(Object element) {
        return super.getModelContext(element);
    }

    public boolean hasCreateProjectWithoutRepositorySupport() {
        return true;
    }

    private static class WorkspaceProjectObserver
    extends EContentAdapter {
        private InternalProject project;

        public WorkspaceProjectObserver(InternalProject project) {
            this.project = project;
        }

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (notification.getNotifier() instanceof EObject) {
                EReference eReference;
                EObject eObject = (EObject)notification.getNotifier();
                this.project.notifyObjectsChanged(Collections.singleton(eObject), false);
                Object feature = notification.getFeature();
                if (feature instanceof EReference && (eReference = (EReference)feature).isContainment() && notification.getNewValue() instanceof EObject) {
                    this.project.notifyObjectsChanged(Collections.singleton(notification.getNewValue()), true);
                }
            }
        }
    }
}

