/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.cdo.internal.ui.handlers;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.workspace.CDOWorkspace;
import org.eclipse.emf.ecp.cdo.internal.ui.Activator;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.services.IEvaluationService;

public abstract class AbstractWorkspaceHandler
extends AbstractHandler {
    private final String jobName;

    public AbstractWorkspaceHandler(String jobName) {
        this.jobName = jobName;
    }

    public final String getJobName() {
        return this.jobName;
    }

    public final Object execute(ExecutionEvent event) throws ExecutionException {
        Object element;
        CDOWorkspace workspace;
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && (workspace = (CDOWorkspace)AdapterUtil.adapt((Object)(element = ((IStructuredSelection)selection).getFirstElement()), CDOWorkspace.class)) != null) {
            try {
                if (this.jobName == null) {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                AbstractWorkspaceHandler.this.execute(event, workspace, monitor);
                            }
                            catch (Exception ex) {
                                Activator.log(ex);
                            }
                        }
                    });
                } else {
                    new Job(this.jobName){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                AbstractWorkspaceHandler.this.execute(event, workspace, monitor);
                                return Status.OK_STATUS;
                            }
                            catch (Exception ex) {
                                return new Status(4, "org.eclipse.emf.ecp.cdo.ui", ex.getMessage(), (Throwable)ex);
                            }
                        }
                    }.schedule();
                }
            }
            catch (Exception ex) {
                throw new ExecutionException("Problem while handling " + element, (Throwable)ex);
            }
        }
        return null;
    }

    protected abstract void execute(ExecutionEvent var1, CDOWorkspace var2, IProgressMonitor var3) throws Exception;

    public static void refreshDirtyState(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow ww = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        IEvaluationService service = (IEvaluationService)ww.getService(IEvaluationService.class);
        if (service != null) {
            service.requestEvaluation("org.eclipse.emf.cdo.workspace.dirty");
        }
    }
}

