/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ui.dialogs;

import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.internal.ui.Messages;
import org.eclipse.emf.ecp.internal.ui.dialogs.PropertiesDialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ProjectPropertiesDialog
extends PropertiesDialog {
    private final ECPProject project;
    private Text nameText;
    private Text repositoryText;
    private Text providerText;

    public ProjectPropertiesDialog(Shell parentShell, boolean editable, ECPProject project) {
        super(parentShell, project.getName(), String.valueOf(Messages.ProjectPropertiesDialog_DialogTitle_ProjectIs) + (project.isOpen() ? Messages.ProjectPropertiesDialog_DialogTitle_Open : Messages.ProjectPropertiesDialog_DialogTitle_Closed) + ".", editable, project.getProperties());
        this.project = project;
    }

    public final ECPProject getProject() {
        return this.project;
    }

    public final Text getNameText() {
        return this.nameText;
    }

    public final Text getRepositoryText() {
        return this.repositoryText;
    }

    public final Text getProviderText() {
        return this.providerText;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ProjectPropertiesDialog_DialogTitle);
    }

    protected void createSpecialProperties(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.repositoryText = this.addTextProperty(composite, Messages.ProjectPropertiesDialog_ProjectRepository, this.project.getRepository() != null ? this.project.getRepository().getLabel() : "");
        this.providerText = this.addTextProperty(composite, Messages.ProjectPropertiesDialog_ProjectProvider, this.project.getProvider().getLabel());
    }
}

