/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.internal.swt;

import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecp.edit.internal.swt.ImageDescriptorToImage;
import org.eclipse.emf.ecp.edit.spi.ECPControlFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.emf.ecp.edit.swt";
    private static Activator plugin;
    private final Map<String, ImageDescriptorToImage> imageRegistry = new LinkedHashMap<String, ImageDescriptorToImage>(20, 0.8f, true){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean removeEldestEntry(Map.Entry<String, ImageDescriptorToImage> eldest) {
            return this.size() > 20;
        }

        @Override
        public ImageDescriptorToImage remove(Object arg0) {
            ImageDescriptorToImage image = (ImageDescriptorToImage)super.remove(arg0);
            image.getImage().dispose();
            return image;
        }
    };
    private ServiceReference<ECPControlFactory> controlFactoryReference;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
        for (ImageDescriptorToImage descriptorToImage : this.imageRegistry.values()) {
            descriptorToImage.getImage().dispose();
        }
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void logException(Exception e) {
        Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), e.getMessage(), (Throwable)e));
    }

    public static Image getImage(String path) {
        if (!Activator.getDefault().imageRegistry.containsKey(path)) {
            Activator.getDefault().imageRegistry.put(path, new ImageDescriptorToImage(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource(path))));
        }
        return Activator.getDefault().imageRegistry.get(path).getImage();
    }

    public static Image getImage(URL url) {
        if (!Activator.getDefault().imageRegistry.containsKey(url == null ? "NULL" : url.toExternalForm())) {
            Activator.getDefault().imageRegistry.put(url == null ? "NULL" : url.toExternalForm(), new ImageDescriptorToImage(ImageDescriptor.createFromURL((URL)url)));
        }
        return Activator.getDefault().imageRegistry.get(url == null ? "NULL" : url.toExternalForm()).getImage();
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        if (!Activator.getDefault().imageRegistry.containsKey(path)) {
            Activator.getDefault().imageRegistry.put(path, new ImageDescriptorToImage(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource(path))));
        }
        return Activator.getDefault().imageRegistry.get(path).getImageDescriptor();
    }

    public ECPControlFactory getECPControlFactory() {
        if (this.controlFactoryReference == null) {
            this.controlFactoryReference = plugin.getBundle().getBundleContext().getServiceReference(ECPControlFactory.class);
        }
        return (ECPControlFactory)plugin.getBundle().getBundleContext().getService(this.controlFactoryReference);
    }

    public void ungetECPControlFactory() {
        if (this.controlFactoryReference == null) {
            return;
        }
        plugin.getBundle().getBundleContext().ungetService(this.controlFactoryReference);
        this.controlFactoryReference = null;
    }
}

