/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.internal.swt.controls;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecp.edit.internal.swt.Activator;
import org.eclipse.emf.ecp.edit.internal.swt.util.SWTControl;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;

public abstract class SingleControl
extends SWTControl {
    private static final String VALIDATION_ERROR_ICON = "icons/validation_error.png";
    private ControlDecoration controlDecoration;

    public void handleValidation(Diagnostic diagnostic) {
        if (diagnostic.getData().size() < 2) {
            return;
        }
        if (!diagnostic.getData().get(0).equals(this.getModelElementContext().getModelElement()) || !diagnostic.getData().get(1).equals(this.getStructuralFeature())) {
            return;
        }
        if (diagnostic.getSeverity() == 4 || diagnostic.getSeverity() == 2) {
            Image image = Activator.getImage(VALIDATION_ERROR_ICON);
            Diagnostic reason = diagnostic;
            if (diagnostic.getChildren() != null && diagnostic.getChildren().size() != 0) {
                reason = (Diagnostic)diagnostic.getChildren().get(0);
            }
            if (this.validationLabel != null) {
                this.validationLabel.setImage(image);
                this.validationLabel.setToolTipText(reason.getMessage());
            }
            if (this.controlDecoration != null) {
                this.controlDecoration.setDescriptionText(reason.getMessage());
                this.controlDecoration.show();
            }
            this.updateValidationColor(this.getSystemColor(3));
        } else {
            this.resetValidation();
        }
    }

    protected void updateValidationColor(Color color) {
    }

    protected void addControlDecoration(Control control) {
    }

    public void resetValidation() {
        if (this.validationLabel == null || this.validationLabel.isDisposed()) {
            return;
        }
        this.validationLabel.setImage(null);
        this.validationLabel.setToolTipText("");
        this.updateValidationColor(null);
        if (this.controlDecoration != null) {
            this.controlDecoration.hide();
        }
    }

    public void dispose() {
        if (this.validationLabel != null) {
            this.validationLabel.dispose();
        }
        if (this.controlDecoration != null) {
            this.controlDecoration.dispose();
        }
    }

    @Deprecated
    public boolean showLabel() {
        return true;
    }
}

