/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ui.commands;

import java.io.File;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.ui.platform.Activator;
import org.eclipse.emf.ecp.ui.platform.PreferenceHelper;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class ImportRootHandler
extends AbstractHandler {
    public static final String[] FILTER_EXTS = new String[]{"*.xmi"};
    public static final String[] FILTER_NAMES = new String[]{"Model Files (*.xmi)"};
    private static final String IMPORT_MODEL_PATH = "org.eclipse.emf.emfstore.client.ui.importModelPath";
    private boolean imported;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ECPProject ecpProject = (ECPProject)((IStructuredSelection)HandlerUtil.getActiveMenuSelection((ExecutionEvent)event)).getFirstElement();
        if (ecpProject == null) {
            return null;
        }
        String fileName = this.getFileName();
        if (fileName == null) {
            return null;
        }
        URI fileURI = URI.createFileURI((String)fileName);
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(fileURI, true);
        this.importFile(ecpProject, fileURI, resource, HandlerUtil.getActiveShell((ExecutionEvent)event));
        return null;
    }

    private void importFile(final ECPProject parentObject, URI fileURI, Resource resource, Shell shell) {
        block6: {
            this.imported = false;
            ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(shell);
            try {
                try {
                    progressDialog.open();
                    progressDialog.getProgressMonitor().beginTask("Import model...", 100);
                    final EObject eObjectImport = (EObject)resource.getContents().get(0);
                    EditingDomain editingDomain = parentObject.getEditingDomain();
                    editingDomain.getCommandStack().execute((Command)new ChangeCommand((Notifier)eObjectImport){

                        protected void doExecute() {
                            parentObject.getContents().add((Object)EcoreUtil.copy((EObject)eObjectImport));
                            ImportRootHandler.this.imported = true;
                        }
                    });
                }
                catch (RuntimeException e) {
                    Activator.log(e.getMessage(), e);
                    progressDialog.getProgressMonitor().done();
                    progressDialog.close();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                progressDialog.getProgressMonitor().done();
                progressDialog.close();
                throw throwable;
            }
            progressDialog.getProgressMonitor().done();
            progressDialog.close();
        }
        if (!this.imported) {
            MessageDialog.openWarning((Shell)shell, (String)"No Imports", (String)"No Objects were imported, the model element you selected probably can't contain the element you try to import.");
        }
    }

    private String getFileName() {
        FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 4096);
        dialog.setFilterNames(FILTER_NAMES);
        dialog.setFilterExtensions(FILTER_EXTS);
        String initialPath = PreferenceHelper.getPreference(IMPORT_MODEL_PATH, System.getProperty("user.home"));
        dialog.setFilterPath(initialPath);
        String fileName = dialog.open();
        if (fileName == null) {
            return null;
        }
        File file = new File(dialog.getFilterPath(), dialog.getFileName());
        PreferenceHelper.setPreference(IMPORT_MODEL_PATH, file.getParent());
        return file.getAbsolutePath();
    }
}

