/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.editor.controls;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.databinding.Binding;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.internal.swt.controls.SingleControl;
import org.eclipse.emf.ecp.view.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.rule.model.LeafCondition;
import org.eclipse.emf.ecp.view.rule.model.RulePackage;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;

public class ExpectedValueControl
extends SingleControl {
    private Label text;

    private String getTextVariantID() {
        return "org_eclipse_emf_ecp_view_editor_controls_ruleattribute";
    }

    protected void updateValidationColor(Color color) {
        this.text.setBackground(color);
    }

    protected void fillControlComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)composite);
        Button bSelectObject = new Button(composite, 8);
        bSelectObject.setText("Select Object");
        this.text = new Label(composite, 2052);
        this.text.setLayoutData((Object)new GridData(4, 4, true, true));
        this.text.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getTextVariantID());
        bSelectObject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                LeafCondition condition = (LeafCondition)ExpectedValueControl.this.getModelElementContext().getModelElement();
                EStructuralFeature structuralFeature = ((VFeaturePathDomainModelReference)condition.getDomainModelReference()).getDomainModelEFeature();
                if (structuralFeature == null) {
                    MessageDialog.openError((Shell)ExpectedValueControl.this.text.getShell(), (String)"No Attribute selected", (String)"Please select an attribute first. Without the attribute we can't provide you with support!");
                    return;
                }
                if (EReference.class.isInstance(structuralFeature)) {
                    return;
                }
                EAttribute attribute = (EAttribute)structuralFeature;
                Class attribuetClazz = attribute.getEAttributeType().getInstanceClass();
                if (attribuetClazz.isPrimitive()) {
                    if (Integer.TYPE.isAssignableFrom(attribuetClazz)) {
                        attribuetClazz = Integer.class;
                    } else if (Long.TYPE.isAssignableFrom(attribuetClazz)) {
                        attribuetClazz = Long.class;
                    } else if (Float.TYPE.isAssignableFrom(attribuetClazz)) {
                        attribuetClazz = Float.class;
                    } else if (Double.TYPE.isAssignableFrom(attribuetClazz)) {
                        attribuetClazz = Double.class;
                    } else if (Boolean.TYPE.isAssignableFrom(attribuetClazz)) {
                        attribuetClazz = Boolean.class;
                    } else if (Character.TYPE.isAssignableFrom(attribuetClazz)) {
                        attribuetClazz = Character.class;
                    }
                }
                Object object = null;
                if (Enum.class.isAssignableFrom(attribuetClazz)) {
                    T[] enumValues = attribuetClazz.getEnumConstants();
                    ListDialog ld = new ListDialog(ExpectedValueControl.this.text.getShell());
                    ld.setLabelProvider((ILabelProvider)new LabelProvider());
                    ld.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
                    ld.setInput(enumValues);
                    ld.setInitialSelections(new Object[]{enumValues[0]});
                    ld.setMessage("Please select the enum value to set.");
                    ld.setTitle("Select a value");
                    int enumSelectionResult = ld.open();
                    if (enumSelectionResult == 0) {
                        object = ld.getResult()[0];
                    }
                } else if (String.class.isAssignableFrom(attribuetClazz) || Number.class.isAssignableFrom(attribuetClazz) || Boolean.class.isAssignableFrom(attribuetClazz)) {
                    try {
                        Constructor constructor = attribuetClazz.getConstructor(String.class);
                        InputDialog id = new InputDialog(ExpectedValueControl.this.text.getShell(), "Insert the value", "The value must be parseable by the " + attribuetClazz.getSimpleName() + " class. For a double value please use the #.# format. For boolean values 'true' or 'false'.", null, null);
                        int inputResult = id.open();
                        if (inputResult == 0) {
                            object = constructor.newInstance(id.getValue());
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (SecurityException securityException) {
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    catch (InstantiationException instantiationException) {
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (InvocationTargetException invocationTargetException) {}
                } else {
                    MessageDialog.openError((Shell)ExpectedValueControl.this.text.getShell(), (String)"Not primitive Attribute selected", (String)"The selected attribute has a not primitive type. We can't provide you support for it!");
                }
                if (object != null) {
                    EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)condition);
                    editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)condition, (Object)RulePackage.eINSTANCE.getLeafCondition_ExpectedValue(), object));
                    ExpectedValueControl.this.text.setText(object.toString());
                }
            }
        });
    }

    public void setEditable(boolean isEditable) {
    }

    public Binding bindValue() {
        if (this.getModelValue().getValue() != null) {
            this.text.setText(this.getModelValue().getValue().toString());
        }
        return null;
    }

    protected String getHelpText() {
        return "";
    }

    protected Control[] getControlsForTooltip() {
        return new Control[]{this.text};
    }

    protected String getUnsetButtonTooltip() {
        return "Unset Button";
    }

    protected String getUnsetLabelText() {
        return "Unset Button";
    }
}

