/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ui.view.emf;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecp.internal.ui.view.Activator;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class ExtendedColorRegistry {
    public static final ExtendedColorRegistry INSTANCE = new ExtendedColorRegistry();
    protected Display display;
    protected HashMap<Collection<?>, Color> table = new HashMap(10);

    public ExtendedColorRegistry() {
        this.display = Display.getCurrent();
        this.hookDisplayDispose(this.display);
    }

    public ExtendedColorRegistry(Display display) {
        this.display = display;
        this.hookDisplayDispose(display);
    }

    public Color getColor(Color foregroundColor, Color backgroundColor, Object object) {
        if (object instanceof Color) {
            return (Color)object;
        }
        ArrayList<Object> key = new ArrayList<Object>(2);
        key.add(foregroundColor);
        key.add(backgroundColor);
        key.add(object);
        Color result = this.table.get(key);
        if (result == null) {
            if (object instanceof ColorDescriptor) {
                ColorDescriptor colorDescriptor = (ColorDescriptor)object;
                try {
                    result = colorDescriptor.createColor((Device)this.display);
                }
                catch (DeviceResourceException exception) {
                    Activator.log((Exception)((Object)exception));
                }
            } else if (object instanceof URI) {
                RGB colorData;
                URI colorURI = (URI)object;
                if (!"color".equals(colorURI.scheme())) {
                    throw new IllegalArgumentException("Only 'color' scheme is recognized" + colorURI);
                }
                if ("rgb".equals(colorURI.authority())) {
                    int red = Integer.parseInt(colorURI.segment(0));
                    int green = Integer.parseInt(colorURI.segment(1));
                    int blue = Integer.parseInt(colorURI.segment(2));
                    colorData = new RGB(red, green, blue);
                } else if ("hsb".equals(colorURI.authority())) {
                    float[] hsb = new float[3];
                    int i = 0;
                    while (i < 3) {
                        String segment = colorURI.segment(i);
                        hsb[i] = "".equals(segment) || "foreground".equals(segment) ? foregroundColor.getRGB().getHSB()[i] : ("background".equals(segment) ? backgroundColor.getRGB().getHSB()[i] : Float.parseFloat(segment));
                        ++i;
                    }
                    colorData = new RGB(hsb[0], hsb[1], hsb[2]);
                } else {
                    throw new IllegalArgumentException("Only 'rgb' and 'hsb' authority are recognized" + colorURI);
                }
                try {
                    result = ColorDescriptor.createFrom((RGB)colorData).createColor((Device)this.display);
                }
                catch (DeviceResourceException exception) {
                    Activator.log((Exception)((Object)exception));
                }
            }
            if (result != null) {
                this.table.put(key, result);
            }
        }
        return result;
    }

    protected void handleDisplayDispose() {
        for (Color color : this.table.values()) {
            color.dispose();
        }
        this.table = null;
    }

    protected void hookDisplayDispose(Display display) {
        display.disposeExec(new Runnable(){

            public void run() {
                ExtendedColorRegistry.this.handleDisplayDispose();
            }
        });
    }
}

