/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ui.view.swt.internal;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecp.internal.ui.view.Activator;
import org.eclipse.emf.ecp.internal.ui.view.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.internal.ui.view.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.internal.ui.view.renderer.Node;
import org.eclipse.emf.ecp.internal.ui.view.renderer.RenderingResultRow;
import org.eclipse.emf.ecp.ui.view.swt.internal.CustomSWTRenderer;
import org.eclipse.emf.ecp.ui.view.swt.internal.SWTCategorizationRenderer;
import org.eclipse.emf.ecp.ui.view.swt.internal.SWTCategoryRenderer;
import org.eclipse.emf.ecp.ui.view.swt.internal.SWTControlRenderer;
import org.eclipse.emf.ecp.ui.view.swt.internal.SWTRenderer;
import org.eclipse.emf.ecp.ui.view.swt.internal.SWTViewRenderer;
import org.eclipse.emf.ecp.view.model.VCategorization;
import org.eclipse.emf.ecp.view.model.VCategory;
import org.eclipse.emf.ecp.view.model.VControl;
import org.eclipse.emf.ecp.view.model.VElement;
import org.eclipse.emf.ecp.view.model.VView;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SWTRenderers
implements SWTRenderer<VElement> {
    public static final SWTRenderers INSTANCE = new SWTRenderers();
    private final Map<Class<? extends VElement>, SWTRenderer> renderers = new LinkedHashMap<Class<? extends VElement>, SWTRenderer>();

    public SWTRenderers() {
        this.renderers.put(VControl.class, SWTControlRenderer.INSTANCE);
        this.renderers.put(VCategorization.class, SWTCategorizationRenderer.INSTANCE);
        this.renderers.put(VView.class, SWTViewRenderer.INSTANCE);
        this.renderers.put(VCategory.class, SWTCategoryRenderer.INSTANCE);
        for (CustomSWTRenderer customRenderer : this.getCustomRenderers()) {
            for (Map.Entry<Class<VElement>, SWTRenderer<?>> renderEntry : customRenderer.getCustomRenderers().entrySet()) {
                this.renderers.put(renderEntry.getKey(), renderEntry.getValue());
            }
        }
    }

    public Set<CustomSWTRenderer> getCustomRenderers() {
        LinkedHashSet<CustomSWTRenderer> renderers = new LinkedHashSet<CustomSWTRenderer>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.emf.ecp.ui.view.swt.customSWTRenderers");
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement configurationElement = extension.getConfigurationElements()[0];
            try {
                CustomSWTRenderer renderer = (CustomSWTRenderer)configurationElement.createExecutableExtension("class");
                renderers.add(renderer);
            }
            catch (CoreException ex) {
                Activator.log((Exception)((Object)ex));
            }
            ++n2;
        }
        return renderers;
    }

    public List<RenderingResultRow<Control>> render(Node<VElement> node, AdapterFactoryItemDelegator adapterFactoryItemDelegator, Object ... initData) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        Class<?> c = null;
        for (Class<? extends VElement> cls : this.renderers.keySet()) {
            Class<?>[] interfaces = node.getRenderable().getClass().getInterfaces();
            int indexOf = Arrays.asList(interfaces).indexOf(cls);
            if (indexOf == -1) continue;
            c = interfaces[indexOf];
            break;
        }
        if (c != null) {
            SWTRenderer swtRenderer = this.renderers.get(c);
            return swtRenderer.render(node, adapterFactoryItemDelegator, initData);
        }
        throw new NoRendererFoundException("No renderer found for renderable " + node.getRenderable());
    }

    public List<RenderingResultRow<Control>> render(Composite parent, Node node, AdapterFactoryItemDelegator adapterFactoryItemDelegator) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        return this.render((Node<VElement>)node, adapterFactoryItemDelegator, parent);
    }
}

