/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ui.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecp.edit.spi.ECPControlContext;
import org.eclipse.emf.ecp.internal.ui.view.SelectedNodeChangedListener;
import org.eclipse.emf.ecp.internal.ui.view.renderer.Node;
import org.eclipse.emf.ecp.internal.ui.view.renderer.SelectedChildNodeListener;
import org.eclipse.emf.ecp.view.model.VElement;
import org.eclipse.emf.ecp.view.model.VView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RendererContext<CONTROL>
implements SelectedChildNodeListener {
    private final Map<EStructuralFeature, Set<EObject>> categoryValidationMap = new HashMap<EStructuralFeature, Set<EObject>>();
    private final Map<EObject, Set<Diagnostic>> validationMap = new HashMap<EObject, Set<Diagnostic>>();
    private final Node<? extends VElement> node;
    private boolean alive = true;
    private VElement renderable;
    private ECPControlContext context;
    private final Set<ValidationListener> listeners = new HashSet<ValidationListener>();
    private ValidationSeverityModifier validationSeverityHandler;
    private EContentAdapter contentAdapter;
    private CONTROL control;
    private final List<SelectedNodeChangedListener> selectionChangedListeners;

    public RendererContext(Node<? extends VElement> node, ECPControlContext context) {
        this.node = node;
        this.renderable = node.getRenderable();
        this.selectionChangedListeners = new ArrayList<SelectedNodeChangedListener>();
        this.context = context;
        if (node.getRenderable() instanceof VView) {
            node.addSelectedChildNodeListener(this);
        }
    }

    public void setValidationSeverityHandler(ValidationSeverityModifier validationSeverityHandler) {
        this.validationSeverityHandler = validationSeverityHandler;
    }

    public void addListener(ValidationListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ValidationListener listener) {
        this.listeners.remove(listener);
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void dispose() {
        this.alive = false;
        this.listeners.clear();
        this.validationMap.clear();
        this.categoryValidationMap.clear();
        this.selectionChangedListeners.clear();
        this.node.dispose();
        this.context = null;
        this.renderable = null;
        this.contentAdapter = null;
    }

    public Integer getSeverity(EObject object) {
        if (this.validationMap.containsKey(object)) {
            int maxValue = 0;
            for (Diagnostic diagnostic : this.validationMap.get(object)) {
                if (diagnostic.getSeverity() <= maxValue) continue;
                maxValue = diagnostic.getSeverity();
            }
            return maxValue;
        }
        return 0;
    }

    public Map<EObject, Set<Diagnostic>> getValidationMap() {
        return Collections.unmodifiableMap(this.validationMap);
    }

    public void setRenderedResult(CONTROL control) {
        this.control = control;
    }

    public CONTROL getControl() {
        return this.control;
    }

    public void addSelectionChangedListener(SelectedNodeChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(SelectedNodeChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    private <T extends VElement> void fireSelectionChanged(T selectedRenderable) {
        for (SelectedNodeChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(selectedRenderable);
        }
    }

    @Override
    public void childSelected(Node<?> child) {
        this.fireSelectionChanged((VElement)child.getRenderable());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ValidationListener {
        public void validationChanged(Map<EObject, Set<Diagnostic>> var1);
    }

    public static interface ValidationSeverityModifier {
        public int getSeverityForDiagnostic(Diagnostic var1, EStructuralFeature var2);
    }
}

