/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ui.view.builders;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecp.edit.spi.ECPControlContext;
import org.eclipse.emf.ecp.internal.ui.view.Activator;
import org.eclipse.emf.ecp.internal.ui.view.builders.CategorizationNodeBuilder;
import org.eclipse.emf.ecp.internal.ui.view.builders.CategoryNodeBuilder;
import org.eclipse.emf.ecp.internal.ui.view.builders.ControlNodeBuilder;
import org.eclipse.emf.ecp.internal.ui.view.builders.CustomNodeBuilder;
import org.eclipse.emf.ecp.internal.ui.view.builders.NodeBuilder;
import org.eclipse.emf.ecp.internal.ui.view.builders.RenderableNodeBuilder;
import org.eclipse.emf.ecp.internal.ui.view.builders.ViewNodeBuilder;
import org.eclipse.emf.ecp.internal.ui.view.renderer.Node;
import org.eclipse.emf.ecp.view.model.VCategorization;
import org.eclipse.emf.ecp.view.model.VCategory;
import org.eclipse.emf.ecp.view.model.VControl;
import org.eclipse.emf.ecp.view.model.VElement;
import org.eclipse.emf.ecp.view.model.VView;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeBuilders {
    public static final NodeBuilders INSTANCE = new NodeBuilders();
    private Map<Class<? extends VElement>, NodeBuilder<? extends VElement>> builders;
    private boolean buildersInitialized;

    private NodeBuilders() {
    }

    private void initBuilders() {
        this.builders = new LinkedHashMap<Class<? extends VElement>, NodeBuilder<? extends VElement>>(){
            {
                this.put(VControl.class, new RenderableNodeBuilder());
                this.put(VView.class, new ViewNodeBuilder());
                this.put(VCategory.class, new CategoryNodeBuilder());
                this.put(VCategorization.class, new CategorizationNodeBuilder());
                this.put(VControl.class, new ControlNodeBuilder());
            }
        };
        for (CustomNodeBuilder customBuilder : this.getCustomNodeBuilders()) {
            for (Map.Entry<Class<? extends VElement>, NodeBuilder<? extends VElement>> entry : customBuilder.getCustomNodeBuilders().entrySet()) {
                this.builders.put(entry.getKey(), entry.getValue());
            }
        }
        this.buildersInitialized = true;
    }

    public Set<CustomNodeBuilder> getCustomNodeBuilders() {
        LinkedHashSet<CustomNodeBuilder> builders = new LinkedHashSet<CustomNodeBuilder>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.emf.ecp.ui.view.customNodeBuilders");
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement configurationElement = extension.getConfigurationElements()[0];
            try {
                CustomNodeBuilder renderer = (CustomNodeBuilder)configurationElement.createExecutableExtension("class");
                builders.add(renderer);
            }
            catch (CoreException ex) {
                Activator.log((Exception)((Object)ex));
            }
            ++n2;
        }
        return builders;
    }

    public <R extends VElement> Node<R> build(R renderable, ECPControlContext controlContext) {
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        AdapterFactoryItemDelegator adapterFactoryItemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)composedAdapterFactory);
        Node<R> build = this.build(renderable, controlContext, adapterFactoryItemDelegator);
        composedAdapterFactory.dispose();
        return build;
    }

    public <R extends VElement> Node<R> build(R renderable, ECPControlContext controlContext, AdapterFactoryItemDelegator adapterFactoryItemDelegator) {
        if (!this.buildersInitialized) {
            this.initBuilders();
        }
        Class<?> c = null;
        for (Class<? extends VElement> cls : this.builders.keySet()) {
            Class<?>[] interfaces = renderable.getClass().getInterfaces();
            int indexOf = Arrays.asList(interfaces).indexOf(cls);
            if (indexOf == -1) continue;
            c = interfaces[indexOf];
            break;
        }
        if (c != null) {
            NodeBuilder<? extends VElement> builder = this.builders.get(c);
            return builder.build(renderable, controlContext, adapterFactoryItemDelegator);
        }
        return null;
    }
}

