/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ui.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredEClassContentProvider
implements ITreeContentProvider {
    private Map<EPackage, Set<EClass>> packageClassesMap = new HashMap<EPackage, Set<EClass>>();

    public FilteredEClassContentProvider(Collection<EPackage> unsupportedEPackages, Collection<EPackage> projectFilteredEPackages, Collection<EClass> projectFilteredEClasss) {
        for (EPackage ePackage : ECPUtil.getAllRegisteredEPackages()) {
            if (unsupportedEPackages.contains(ePackage)) continue;
            boolean addToPackages = projectFilteredEPackages.contains(ePackage);
            for (EClassifier classifier : ePackage.getEClassifiers()) {
                if (!(classifier instanceof EClass) || ((EClass)classifier).isAbstract()) continue;
                EClass eClass = (EClass)classifier;
                if (!addToPackages && !projectFilteredEClasss.contains(eClass)) continue;
                if (!this.packageClassesMap.containsKey(ePackage)) {
                    this.packageClassesMap.put(ePackage, new HashSet());
                }
                this.packageClassesMap.get(ePackage).add(eClass);
            }
        }
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        if (this.packageClassesMap.size() == 1) {
            return this.packageClassesMap.values().iterator().next().toArray();
        }
        return this.packageClassesMap.keySet().toArray();
    }

    public Object[] getChildren(Object parentElement) {
        if (EPackage.class.isInstance(parentElement)) {
            return this.packageClassesMap.get(parentElement).toArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        if (EClass.class.isInstance(element)) {
            return ((EClass)element).getEPackage();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.packageClassesMap.containsKey(element);
    }
}

