/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ui.model;

import java.util.Collection;
import org.eclipse.emf.ecp.core.ECPProvider;
import org.eclipse.emf.ecp.core.ECPRepository;
import org.eclipse.emf.ecp.core.ECPRepositoryManager;
import org.eclipse.emf.ecp.core.util.ECPProviderAware;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.core.util.observer.ECPObserver;
import org.eclipse.emf.ecp.core.util.observer.ECPRepositoriesChangedObserver;
import org.eclipse.emf.ecp.core.util.observer.ECPRepositoryContentChangedObserver;
import org.eclipse.emf.ecp.internal.ui.model.ECPContentProvider;
import org.eclipse.emf.ecp.spi.core.InternalProvider;
import org.eclipse.emf.ecp.spi.core.util.InternalChildrenList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoriesContentProvider
extends ECPContentProvider<ECPRepositoryManager>
implements ECPRepositoriesChangedObserver,
ECPRepositoryContentChangedObserver {
    private final ECPProvider allowedProvider;

    public RepositoriesContentProvider() {
        this.allowedProvider = null;
    }

    public RepositoriesContentProvider(ECPProvider allowedProvider) {
        this.allowedProvider = allowedProvider;
    }

    public void repositoriesChanged(Collection<ECPRepository> oldRepositories, Collection<ECPRepository> newRepositories) {
        this.refreshViewer();
    }

    public void contentChanged(ECPRepository repository, Collection<Object> objects) {
        this.refreshViewer(true, objects.toArray());
    }

    @Override
    protected void connectInput(ECPRepositoryManager input) {
        super.connectInput(input);
        ECPUtil.getECPObserverBus().register((ECPObserver)this);
    }

    @Override
    protected void disconnectInput(ECPRepositoryManager input) {
        ECPUtil.getECPObserverBus().register((ECPObserver)this);
        super.disconnectInput(input);
    }

    @Override
    protected boolean isSlow(Object parent) {
        InternalProvider provider;
        if (parent instanceof ECPProviderAware && (provider = (InternalProvider)((ECPProviderAware)parent).getProvider()) != null) {
            return provider.isSlow(parent);
        }
        return super.isSlow(parent);
    }

    @Override
    protected void fillChildren(Object parent, InternalChildrenList childrenList) {
        if (parent == ECPUtil.getECPRepositoryManager()) {
            if (this.allowedProvider == null) {
                childrenList.addChildren(ECPUtil.getECPRepositoryManager().getRepositories());
            } else {
                for (ECPRepository ecpRepository : ECPUtil.getECPRepositoryManager().getRepositories()) {
                    if (!this.allowedProvider.equals(ecpRepository.getProvider())) continue;
                    childrenList.addChild((Object)ecpRepository);
                }
            }
        } else {
            super.fillChildren(parent, childrenList);
        }
    }
}

