/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ui.common;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.core.util.ECPContainer;
import org.eclipse.emf.ecp.core.util.ECPModelContextProvider;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.internal.core.Activator;
import org.eclipse.emf.ecp.internal.ui.model.ModelContentProvider;
import org.eclipse.emf.ecp.internal.ui.model.ModelLabelProvider;
import org.eclipse.emf.ecp.internal.ui.model.RepositoriesContentProvider;
import org.eclipse.emf.ecp.internal.ui.model.RepositoriesLabelProvider;
import org.eclipse.emf.ecp.ui.common.dnd.ECPDropAdapter;
import org.eclipse.emf.ecp.ui.common.dnd.ModelExplorerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public final class TreeViewerFactory {
    private TreeViewerFactory() {
    }

    public static TreeViewer createModelExplorerViewer(Composite parent, boolean hasDnD, ILabelDecorator labelDecorator) {
        final ModelContentProvider contentProvider = new ModelContentProvider();
        final TreeViewer viewer = TreeViewerFactory.createTreeViewer(parent, (ILabelProvider)new ModelLabelProvider(contentProvider), contentProvider, ECPUtil.getECPProjectManager(), labelDecorator, false);
        if (hasDnD) {
            final ECPDropAdapter dropAdapter = TreeViewerFactory.getDropAdapter(contentProvider, viewer);
            int dndOperations = 7;
            Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
            viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
            viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)dropAdapter);
            viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Object[] elements = ((IStructuredSelection)event.getSelection()).toArray();
                    if (elements == null || elements.length == 0) {
                        return;
                    }
                    ECPProject project = null;
                    if (elements[0] instanceof ECPProject) {
                        ECPContainer context = ECPUtil.getModelContext((ECPModelContextProvider)contentProvider, (Object[])elements);
                        if (context != null && context instanceof ECPProject) {
                            project = (ECPProject)context;
                        }
                    } else {
                        ECPModelContextProvider contextProvider = (ECPModelContextProvider)viewer.getContentProvider();
                        project = (ECPProject)ECPUtil.getModelContext((ECPModelContextProvider)contextProvider, (Object[])new Object[]{elements[0]});
                    }
                    if (project != null) {
                        dropAdapter.setEditingDomain(project.getEditingDomain());
                    }
                }
            });
        }
        return viewer;
    }

    private static ECPDropAdapter getDropAdapter(ModelContentProvider contentProvider, TreeViewer viewer) {
        ECPDropAdapter dropAdapter = null;
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.emf.ecp.ui.dropAdapter");
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement configurationElement = extension.getConfigurationElements()[0];
            try {
                dropAdapter = (ECPDropAdapter)((Object)configurationElement.createExecutableExtension("class"));
                dropAdapter.setViewer((Viewer)viewer);
                break;
            }
            catch (CoreException ex) {
                Activator.log((Throwable)ex);
                ++n2;
            }
        }
        if (dropAdapter == null) {
            dropAdapter = new ModelExplorerDropAdapter((Viewer)viewer);
        }
        return dropAdapter;
    }

    public static TreeViewer createRepositoryExplorerViewer(Composite parent, ILabelDecorator labelDecorator) {
        RepositoriesContentProvider contentProvider = new RepositoriesContentProvider();
        TreeViewer viewer = TreeViewerFactory.createTreeViewer(parent, (ILabelProvider)new RepositoriesLabelProvider(contentProvider), contentProvider, ECPUtil.getECPRepositoryManager(), labelDecorator, true);
        return viewer;
    }

    public static TreeViewer createTreeViewer(Composite parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider, Object input, ILabelDecorator labelDecorator, boolean sort) {
        TreeViewer viewer = new TreeViewer(parent, 770);
        TreeViewerFactory.createTreeViewer(labelProvider, contentProvider, input, labelDecorator, viewer, sort);
        return viewer;
    }

    public static TreeViewer createCheckedTreeViewer(Composite parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider, Object input, ILabelDecorator labelDecorator, boolean sort) {
        ContainerCheckedTreeViewer viewer = new ContainerCheckedTreeViewer(parent, 770);
        TreeViewerFactory.createTreeViewer(labelProvider, contentProvider, input, labelDecorator, (TreeViewer)viewer, sort);
        return viewer;
    }

    private static void createTreeViewer(ILabelProvider labelProvider, ITreeContentProvider contentProvider, Object input, ILabelDecorator labelDecorator, TreeViewer viewer, boolean sort) {
        viewer.setContentProvider((IContentProvider)contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        if (sort) {
            viewer.setSorter(new ViewerSorter());
        }
        viewer.setInput(input);
        if (labelDecorator != null && !(labelProvider instanceof DecoratingLabelProvider)) {
            viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider(labelProvider, labelDecorator));
        }
    }
}

