/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ui.view.custom;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.databinding.edit.EMFEditObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.spi.ECPAbstractControl;
import org.eclipse.emf.ecp.edit.spi.ECPControl;
import org.eclipse.emf.ecp.edit.spi.ECPControlFactory;
import org.eclipse.emf.ecp.view.custom.internal.ui.Activator;
import org.eclipse.emf.ecp.view.custom.model.ECPCustomControlChangeListener;
import org.eclipse.emf.ecp.view.custom.model.ECPHardcodedReferences;
import org.eclipse.emf.ecp.view.model.VDomainModelReference;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ECPAbstractCustomControl
extends ECPAbstractControl
implements ECPHardcodedReferences {
    private final CustomControlHelper helper = new CustomControlHelper();
    private final Set<VDomainModelReference> features;
    private final ECPControlFactory controlFactory;
    private final Map<EStructuralFeature, ECPControl> controlMap = new LinkedHashMap<EStructuralFeature, ECPControl>();
    private final Map<VDomainModelReference, Adapter> adapterMap = new LinkedHashMap<VDomainModelReference, Adapter>();

    public ECPAbstractCustomControl(Set<VDomainModelReference> features) {
        if (features == null) {
            features = new LinkedHashSet<VDomainModelReference>();
        }
        this.features = features;
        this.controlFactory = Activator.getECPControlFactory();
    }

    protected final ECPControl getRetrievedControl(EStructuralFeature eStructuralFeature) {
        return this.controlMap.get(eStructuralFeature);
    }

    protected final void resetControlValidation() {
        Set<EStructuralFeature> keySet = this.controlMap.keySet();
        for (EStructuralFeature eStructuralFeature : keySet) {
            ECPControl ecpControl = this.controlMap.get(eStructuralFeature);
            ecpControl.resetValidation();
        }
    }

    protected Binding bindTargetToModel(VDomainModelReference modelFeature, IObservableValue targetValue, UpdateValueStrategy targetToModel, UpdateValueStrategy modelToTarget) {
        EStructuralFeature.Setting setting = this.getSetting(modelFeature);
        IObservableValue modelValue = EMFEditObservables.observeValue((EditingDomain)this.getModelElementContext().getEditingDomain(), (EObject)setting.getEObject(), (EStructuralFeature)setting.getEStructuralFeature());
        return this.getDataBindingContext().bindValue(targetValue, modelValue, targetToModel, modelToTarget);
    }

    protected IObservableList getObservableList(VDomainModelReference domainModelReference) {
        EStructuralFeature.Setting setting = this.getSetting(domainModelReference);
        return EMFEditObservables.observeList((EditingDomain)this.getModelElementContext().getEditingDomain(), (EObject)setting.getEObject(), (EStructuralFeature)setting.getEStructuralFeature());
    }

    protected void setValue(VDomainModelReference modelReference, Object newValue) {
        EStructuralFeature.Setting setting = this.getSetting(modelReference);
        setting.set(newValue);
    }

    protected void registerChangeListener(VDomainModelReference modelReference, final ECPCustomControlChangeListener changeListener) {
        this.adapterMap.containsKey(modelReference);
        final EStructuralFeature.Setting setting = this.getSetting(modelReference);
        AdapterImpl newAdapter = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (msg.isTouch()) {
                    return;
                }
                if (msg.getFeature().equals(setting.getEStructuralFeature())) {
                    super.notifyChanged(msg);
                    changeListener.notifyChanged();
                }
            }
        };
        setting.getEObject().eAdapters().add((Object)newAdapter);
        this.adapterMap.put(modelReference, (Adapter)newAdapter);
    }

    protected Object getValue(VDomainModelReference modelReference) {
        EStructuralFeature.Setting setting = this.getSetting(modelReference);
        return setting.get(false);
    }

    private EStructuralFeature.Setting getSetting(VDomainModelReference modelFeature) {
        Iterator iterator = modelFeature.getIterator();
        int numElments = 0;
        EStructuralFeature.Setting setting = null;
        while (iterator.hasNext()) {
            setting = (EStructuralFeature.Setting)iterator.next();
            ++numElments;
        }
        if (numElments == 0) {
            throw new IllegalStateException("The VDomainModelReference was not initialised.");
        }
        if (numElments > 1) {
            throw new IllegalStateException("The VDomainModelReference is ambigous, please use VDomainModelReference which resolve to exactly one setting.");
        }
        return setting;
    }

    protected final IItemPropertyDescriptor getItemPropertyDescriptor(VDomainModelReference domainModelReference) {
        return this.getItemPropertyDescriptor(this.getSetting(domainModelReference));
    }

    public final Set<VDomainModelReference> getNeededDomainModelReferences() {
        return this.features;
    }

    private String getHelp(VDomainModelReference domainModelReference) {
        if (!this.getNeededDomainModelReferences().contains(domainModelReference)) {
            throw new IllegalArgumentException("The feature must have been registered before!");
        }
        return this.getItemPropertyDescriptor(domainModelReference).getDescription(null);
    }

    private String getLabel(VDomainModelReference domainModelReference) {
        if (!this.getNeededDomainModelReferences().contains(domainModelReference)) {
            throw new IllegalArgumentException("The feature must have been registered before!");
        }
        return this.getItemPropertyDescriptor(domainModelReference).getDisplayName(null);
    }

    @Deprecated
    public final boolean showLabel() {
        return false;
    }

    public void dispose() {
        Activator.ungetECPControlFactory();
        for (VDomainModelReference domainModelReference : this.adapterMap.keySet()) {
            EStructuralFeature.Setting setting = this.getSetting(domainModelReference);
            setting.getEObject().eAdapters().remove((Object)this.adapterMap.get(domainModelReference));
        }
        this.disposeCustomControl();
    }

    protected abstract void disposeCustomControl();

    protected final CustomControlHelper getHelper() {
        return this.helper;
    }

    protected final <T extends ECPControl> T getControl(Class<T> clazz, VDomainModelReference domainModelReference) {
        ECPControl createControl = this.controlFactory.createControl(clazz, this.getItemPropertyDescriptor(domainModelReference), this.getModelElementContext());
        Iterator iterator = domainModelReference.getIterator();
        boolean hasNext = iterator.hasNext();
        if (hasNext) {
            this.controlMap.put(((EStructuralFeature.Setting)iterator.next()).getEStructuralFeature(), createControl);
            return (T)createControl;
        }
        return null;
    }

    public final class CustomControlHelper {
        public String getHelp(VDomainModelReference domainModelReference) {
            return ECPAbstractCustomControl.this.getHelp(domainModelReference);
        }

        public String getLabel(VDomainModelReference domainModelReference) {
            return ECPAbstractCustomControl.this.getLabel(domainModelReference);
        }
    }
}

