/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.groupedgrid.ui.swt.internal;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.internal.swt.util.SWTControl;
import org.eclipse.emf.ecp.edit.spi.ECPControl;
import org.eclipse.emf.ecp.edit.spi.ECPControlContext;
import org.eclipse.emf.ecp.edit.spi.ECPControlFactory;
import org.eclipse.emf.ecp.internal.ui.view.Activator;
import org.eclipse.emf.ecp.internal.ui.view.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.internal.ui.view.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.internal.ui.view.renderer.Node;
import org.eclipse.emf.ecp.internal.ui.view.renderer.RenderingResultRow;
import org.eclipse.emf.ecp.ui.view.swt.internal.AbstractSWTRenderer;
import org.eclipse.emf.ecp.view.model.LabelAlignment;
import org.eclipse.emf.ecp.view.model.VControl;
import org.eclipse.emf.ecp.view.model.VElement;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWTControlRenderer
extends AbstractSWTRenderer<VControl> {
    public static final SWTControlRenderer INSTANCE = new SWTControlRenderer();
    private static final int IDENT = 10;

    public List<RenderingResultRow<Control>> renderSWT(Node<VControl> node, AdapterFactoryItemDelegator adapterFactoryItemDelegator, Object ... initData) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        VControl modelControl = (VControl)node.getRenderable();
        EStructuralFeature.Setting setting = (EStructuralFeature.Setting)modelControl.getDomainModelReference().getIterator().next();
        EClass dataClass = setting.getEStructuralFeature().getEContainingClass();
        ECPControlContext subContext = node.getControlContext();
        if (dataClass == null) {
            return null;
        }
        IItemPropertyDescriptor itemPropertyDescriptor = adapterFactoryItemDelegator.getPropertyDescriptor((Object)setting.getEObject(), (Object)setting.getEStructuralFeature());
        if (itemPropertyDescriptor == null) {
            throw new NoPropertyDescriptorFoundExeption(setting.getEObject(), setting.getEStructuralFeature());
        }
        ECPControlFactory controlFactory = Activator.getDefault().getECPControlFactory();
        if (controlFactory == null) {
            Activator.getDefault().ungetECPControlFactory();
            return null;
        }
        SWTControl control = (SWTControl)controlFactory.createControl(SWTControl.class, itemPropertyDescriptor, subContext);
        if (control == null) {
            return null;
        }
        control.init(node.getControlContext(), modelControl.getDomainModelReference());
        return this.doRender(node, modelControl, subContext, itemPropertyDescriptor, control, initData);
    }

    private List<RenderingResultRow<Control>> doRender(Node<VControl> node, VControl modelControl, ECPControlContext subContext, IItemPropertyDescriptor itemPropertyDescriptor, SWTControl control, Object ... initData) {
        if (control != null) {
            Composite parent = this.getParentFromInitData(initData);
            int numControl = 2;
            Label label = null;
            if (modelControl.getLabelAlignment() == LabelAlignment.LEFT) {
                numControl = 1;
                label = new Label(parent, 0);
                label.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_label");
                label.setBackground(parent.getBackground());
                String extra = "";
                if (((EStructuralFeature)itemPropertyDescriptor.getFeature(null)).getLowerBound() > 0) {
                    extra = "*";
                }
                label.setText(String.valueOf(itemPropertyDescriptor.getDisplayName((Object)subContext.getModelElement())) + extra);
                label.setToolTipText(itemPropertyDescriptor.getDescription((Object)subContext.getModelElement()));
                GridDataFactory.fillDefaults().align(1, 0x1000000).applyTo((Control)label);
                GridDataFactory.createFrom((GridData)((GridData)label.getLayoutData())).indent(10, 0).applyTo((Control)label);
            }
            Composite controlComposite = control.createControl(parent);
            controlComposite.setEnabled(!modelControl.isReadonly());
            controlComposite.setBackground(parent.getBackground());
            if (label == null) {
                node.addRenderingResultDelegator(this.withSWTControls((ECPControl)control, (VElement)modelControl, new Control[]{controlComposite}));
            } else {
                node.addRenderingResultDelegator(this.withSWTControls((ECPControl)control, (VElement)modelControl, new Control[]{controlComposite, label}));
            }
            GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).span(numControl, 1).applyTo((Control)controlComposite);
            if (label == null) {
                return this.createResult(new Control[]{controlComposite});
            }
            return this.createResult(new Control[]{label, controlComposite});
        }
        Activator.getDefault().ungetECPControlFactory();
        return null;
    }
}

