/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.rule;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.internal.rule.NotApplicableForEvaluationException;
import org.eclipse.emf.ecp.view.rule.model.AndCondition;
import org.eclipse.emf.ecp.view.rule.model.Condition;
import org.eclipse.emf.ecp.view.rule.model.LeafCondition;
import org.eclipse.emf.ecp.view.rule.model.OrCondition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConditionEvaluator {
    private ConditionEvaluator() {
    }

    public static boolean evaluate(Condition condition) {
        if (AndCondition.class.isInstance(condition)) {
            return ConditionEvaluator.doEvaluate((AndCondition)condition);
        }
        if (OrCondition.class.isInstance(condition)) {
            return ConditionEvaluator.doEvaluate((OrCondition)condition);
        }
        if (LeafCondition.class.isInstance(condition)) {
            return ConditionEvaluator.doEvaluate((LeafCondition)condition);
        }
        return false;
    }

    public static boolean evaluate(Map<EStructuralFeature.Setting, Object> possibleNewValues, Condition condition) {
        if (AndCondition.class.isInstance(condition)) {
            return ConditionEvaluator.doEvaluate(possibleNewValues, (AndCondition)condition);
        }
        if (OrCondition.class.isInstance(condition)) {
            return ConditionEvaluator.doEvaluate(possibleNewValues, (OrCondition)condition);
        }
        if (LeafCondition.class.isInstance(condition)) {
            return ConditionEvaluator.doEvaluate(possibleNewValues, (LeafCondition)condition);
        }
        return false;
    }

    private static boolean doEvaluate(Map<EStructuralFeature.Setting, Object> possibleNewValues, AndCondition condition) {
        boolean result = true;
        for (Condition innerCondition : condition.getConditions()) {
            result &= ConditionEvaluator.evaluate(possibleNewValues, innerCondition);
        }
        return result;
    }

    private static boolean doEvaluate(Map<EStructuralFeature.Setting, Object> possibleNewValues, OrCondition condition) {
        boolean result = false;
        for (Condition innerCondition : condition.getConditions()) {
            result |= ConditionEvaluator.evaluate(possibleNewValues, innerCondition);
        }
        return result;
    }

    private static boolean doEvaluate(AndCondition condition) {
        boolean result = true;
        for (Condition innerCondition : condition.getConditions()) {
            result &= ConditionEvaluator.evaluate(innerCondition);
        }
        return result;
    }

    private static boolean doEvaluate(OrCondition condition) {
        boolean result = false;
        for (Condition innerCondition : condition.getConditions()) {
            result |= ConditionEvaluator.evaluate(innerCondition);
        }
        return result;
    }

    private static boolean doEvaluate(Map<EStructuralFeature.Setting, Object> possibleNewValues, LeafCondition condition) {
        boolean result = false;
        Object expectedValue = condition.getExpectedValue();
        for (EStructuralFeature.Setting setting : possibleNewValues.keySet()) {
            try {
                result |= ConditionEvaluator.doEvaluate(setting, expectedValue, true, possibleNewValues.get(setting));
            }
            catch (NotApplicableForEvaluationException notApplicableForEvaluationException) {}
        }
        return result;
    }

    private static boolean doEvaluate(LeafCondition condition) {
        Iterator settingIterator = condition.getDomainModelReference().getIterator();
        boolean result = false;
        Object expectedValue = condition.getExpectedValue();
        while (settingIterator.hasNext()) {
            try {
                result |= ConditionEvaluator.doEvaluate((EStructuralFeature.Setting)settingIterator.next(), expectedValue, false, null);
            }
            catch (NotApplicableForEvaluationException notApplicableForEvaluationException) {}
        }
        return result;
    }

    private static boolean doEvaluate(EStructuralFeature.Setting setting, Object expectedValue, boolean useNewValue, Object newValue) throws NotApplicableForEvaluationException {
        EObject parent = setting.getEObject();
        EStructuralFeature feature = setting.getEStructuralFeature();
        EClass attributeClass = feature.getEContainingClass();
        if (!attributeClass.isInstance((Object)parent)) {
            throw new NotApplicableForEvaluationException();
        }
        Object value = !useNewValue ? parent.eGet(feature) : newValue;
        if (!feature.isMany()) {
            if (expectedValue == null) {
                return value == null;
            }
            return expectedValue.equals(value);
        }
        List objects = (List)value;
        return objects.contains(expectedValue);
    }
}

