/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.rule;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.context.AbstractViewService;
import org.eclipse.emf.ecp.view.context.ModelChangeNotification;
import org.eclipse.emf.ecp.view.context.ViewModelContext;
import org.eclipse.emf.ecp.view.internal.rule.ConditionEvaluator;
import org.eclipse.emf.ecp.view.internal.rule.RuleRegistry;
import org.eclipse.emf.ecp.view.model.VAttachment;
import org.eclipse.emf.ecp.view.model.VControl;
import org.eclipse.emf.ecp.view.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.model.VElement;
import org.eclipse.emf.ecp.view.rule.model.Condition;
import org.eclipse.emf.ecp.view.rule.model.EnableRule;
import org.eclipse.emf.ecp.view.rule.model.Rule;
import org.eclipse.emf.ecp.view.rule.model.ShowRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleService
extends AbstractViewService {
    private ViewModelContext context;
    private ViewModelContext.ModelChangeListener domainChangeListener;
    private ViewModelContext.ModelChangeListener viewChangeListener;
    private final RuleRegistry<EnableRule> enableRuleRegistry = new RuleRegistry();
    private final RuleRegistry<ShowRule> showRuleRegistry = new RuleRegistry();
    private boolean isUnset;

    public void instantiate(ViewModelContext context) {
        this.context = context;
        VElement view = context.getViewModel();
        this.domainChangeListener = new ViewModelContext.ModelChangeListener(){

            public void notifyChange(ModelChangeNotification notification) {
                if (RuleService.isAttributeNotification(notification) && !RuleService.this.isUnset) {
                    EAttribute attribute = (EAttribute)notification.getStructuralFeature();
                    RuleService.this.evalShow((EStructuralFeature)attribute);
                    RuleService.this.evalEnable((EStructuralFeature)attribute);
                } else if (RuleService.this.isMultiRefNotification(notification)) {
                    EReference reference = (EReference)notification.getStructuralFeature();
                    EClass eReferenceType = reference.getEReferenceType();
                    for (EAttribute attribute : eReferenceType.getEAllAttributes()) {
                        RuleService.this.evalShow((EStructuralFeature)attribute);
                        RuleService.this.evalEnable((EStructuralFeature)attribute);
                    }
                }
            }

            public void notifyAdd(Notifier notifier) {
            }

            public void notifyRemove(Notifier notifier) {
            }
        };
        context.registerDomainChangeListener(this.domainChangeListener);
        this.viewChangeListener = new ViewModelContext.ModelChangeListener(){

            public void notifyChange(ModelChangeNotification notification) {
            }

            public void notifyAdd(Notifier notifier) {
            }

            public void notifyRemove(Notifier notifier) {
                if (VElement.class.isInstance(notifier)) {
                    VElement renderable = (VElement)VElement.class.cast(notifier);
                    RuleService.this.showRuleRegistry.removeRenderable(renderable);
                    RuleService.this.enableRuleRegistry.removeRenderable(renderable);
                } else if (Condition.class.isInstance(notifier)) {
                    Condition condition = (Condition)Condition.class.cast(notifier);
                    RuleService.resetToVisible(RuleService.this.showRuleRegistry.removeCondition(condition));
                    RuleService.resetToEnabled(RuleService.this.enableRuleRegistry.removeCondition(condition));
                } else if (ShowRule.class.isInstance(notifier)) {
                    ShowRule showRule = (ShowRule)ShowRule.class.cast(notifier);
                    RuleService.resetToVisible(RuleService.this.showRuleRegistry.removeRule(showRule));
                } else if (EnableRule.class.isInstance(notifier)) {
                    EnableRule enableRule = (EnableRule)EnableRule.class.cast(notifier);
                    RuleService.resetToEnabled(RuleService.this.enableRuleRegistry.removeRule(enableRule));
                }
            }
        };
        context.registerViewChangeListener(this.viewChangeListener);
        if (view == null) {
            throw new IllegalStateException("View model must not be null");
        }
        EObject domainModel = context.getDomainModel();
        if (domainModel == null) {
            throw new IllegalStateException("Domain model must not be null");
        }
        this.init(this.enableRuleRegistry, EnableRule.class, (EObject)view, domainModel);
        this.init(this.showRuleRegistry, ShowRule.class, (EObject)view, domainModel);
        this.evalEnable();
        this.evalShow();
    }

    private static void resetToVisible(VElement renderable) {
        if (renderable != null) {
            renderable.setVisible(true);
        }
    }

    private static void resetToEnabled(VElement renderable) {
        if (renderable != null) {
            renderable.setEnabled(true);
        }
    }

    private static Rule getRule(VElement renderable) {
        for (VAttachment attachment : renderable.getAttachments()) {
            if (!Rule.class.isInstance(attachment)) continue;
            Rule rule = (Rule)attachment;
            return rule;
        }
        return null;
    }

    private static void updateStateMap(Map<VElement, Boolean> stateMap, VElement renderable, boolean isOpposite, boolean evalResult) {
        if (!stateMap.containsKey(renderable)) {
            stateMap.put(renderable, isOpposite ? !evalResult : evalResult);
        } else {
            Boolean currentState = (boolean)stateMap.get(renderable);
            if (currentState.booleanValue()) {
                stateMap.put(renderable, isOpposite ? !evalResult : evalResult);
            }
        }
        for (EObject childContent : renderable.eContents()) {
            if (!(childContent instanceof VElement)) continue;
            RuleService.updateStateMap(stateMap, (VElement)childContent, isOpposite, evalResult);
        }
    }

    private static <T extends Rule> boolean hasRule(Class<T> ruleType, EObject eObject) {
        if (!VElement.class.isInstance(eObject)) {
            return false;
        }
        VElement renderable = (VElement)eObject;
        Rule rule = RuleService.getRule(renderable);
        return ruleType.isInstance(rule);
    }

    private static <T extends Rule> Map<VElement, Boolean> evalAffectedRenderables(RuleRegistry<T> registry, Class<T> ruleType, EStructuralFeature attribute, boolean isDryRun, Map<EStructuralFeature.Setting, Object> possibleValues) {
        LinkedHashMap<VElement, Boolean> map = new LinkedHashMap<VElement, Boolean>();
        for (Map.Entry<T, VElement> ruleAndRenderable : registry.getAffectedRenderables(attribute).entrySet()) {
            Rule rule = (Rule)ruleAndRenderable.getKey();
            VElement renderable = ruleAndRenderable.getValue();
            boolean hasChanged = false;
            if (!ruleType.isInstance(rule)) continue;
            if (isDryRun) {
                for (EStructuralFeature.Setting setting : possibleValues.keySet()) {
                    EObject parent = setting.getEObject();
                    EStructuralFeature feature = setting.getEStructuralFeature();
                    EClass attributeClass = feature.getEContainingClass();
                    if (!attributeClass.isInstance((Object)parent)) continue;
                    Object actualValue = parent.eGet(feature);
                    Object newValue = possibleValues.get(setting);
                    if (!feature.isMany()) {
                        if (newValue == null) {
                            hasChanged |= actualValue == null;
                            continue;
                        }
                        hasChanged |= !newValue.equals(actualValue);
                        continue;
                    }
                    List objects = (List)actualValue;
                    hasChanged |= !objects.contains(newValue);
                }
            }
            if (hasChanged) {
                boolean result = ConditionEvaluator.evaluate(possibleValues, rule.getCondition());
                RuleService.updateStateMap(map, renderable, RuleService.isDisableRule(rule) || RuleService.isHideRule(rule), result);
                continue;
            }
            if (isDryRun) continue;
            boolean result = ConditionEvaluator.evaluate(rule.getCondition());
            RuleService.updateStateMap(map, renderable, RuleService.isDisableRule(rule) || RuleService.isHideRule(rule), result);
        }
        return map;
    }

    private static <T extends Rule> Map<VElement, Boolean> evalAffectedRenderables(RuleRegistry<T> registry, Class<T> ruleType, EStructuralFeature attribute, Map<EStructuralFeature.Setting, Object> possibleValues) {
        return RuleService.evalAffectedRenderables(registry, ruleType, attribute, true, possibleValues);
    }

    private static <T extends Rule> Map<VElement, Boolean> evalAffectedRenderables(RuleRegistry<T> registry, Class<T> ruleType, EStructuralFeature attribute) {
        return RuleService.evalAffectedRenderables(registry, ruleType, attribute, false, null);
    }

    private static boolean isDisableRule(Rule rule) {
        if (RuleService.isEnableRule(rule)) {
            EnableRule enableRule = (EnableRule)rule;
            return enableRule.isDisable();
        }
        return false;
    }

    private static boolean isHideRule(Rule rule) {
        if (RuleService.isShowRule(rule)) {
            ShowRule showRule = (ShowRule)rule;
            return showRule.isHide();
        }
        return false;
    }

    private static boolean isShowRule(Rule rule) {
        return rule instanceof ShowRule;
    }

    private <T extends Rule> void evalShow(EStructuralFeature attribute) {
        Map<VElement, Boolean> visibleMap = RuleService.evalAffectedRenderables(this.showRuleRegistry, ShowRule.class, attribute);
        for (Map.Entry<VElement, Boolean> e : visibleMap.entrySet()) {
            Boolean isVisible = e.getValue();
            VElement renderable = e.getKey();
            boolean isCurrentlyVisible = renderable.isVisible();
            renderable.setVisible(isVisible.booleanValue());
            if (!isCurrentlyVisible || isVisible.booleanValue()) continue;
            this.unset(renderable);
        }
    }

    private <T extends Rule> void evalEnable(EStructuralFeature attribute) {
        Map<VElement, Boolean> enabledMap = RuleService.evalAffectedRenderables(this.enableRuleRegistry, EnableRule.class, attribute);
        for (Map.Entry<VElement, Boolean> e : enabledMap.entrySet()) {
            e.getKey().setEnabled(e.getValue().booleanValue());
        }
    }

    private <T extends Rule> void evalShow() {
        for (EStructuralFeature feature : this.showRuleRegistry.getAttributes()) {
            this.evalShow(feature);
        }
    }

    private <T extends Rule> void evalEnable() {
        for (EStructuralFeature feature : this.enableRuleRegistry.getAttributes()) {
            this.evalEnable(feature);
        }
    }

    private <T extends Rule> void init(RuleRegistry<T> registry, Class<T> ruleType, EObject viewModel, EObject domainObject) {
        TreeIterator iterator = viewModel.eAllContents();
        this.register(registry, ruleType, domainObject, viewModel);
        while (iterator.hasNext()) {
            EObject content = (EObject)iterator.next();
            this.register(registry, ruleType, domainObject, content);
        }
    }

    private <T extends Rule> void register(RuleRegistry<T> registry, Class<T> ruleType, EObject domainObject, EObject viewModel) {
        if (RuleService.hasRule(ruleType, viewModel)) {
            VElement renderable = (VElement)viewModel;
            Rule rule = RuleService.getRule(renderable);
            registry.register(renderable, rule, rule.getCondition(), domainObject);
        }
    }

    public Map<VElement, Boolean> getDisabledRenderables(Map<EStructuralFeature.Setting, Object> possibleValues) {
        EStructuralFeature feature = possibleValues.keySet().iterator().next().getEStructuralFeature();
        if (feature instanceof EAttribute) {
            EAttribute attribute = (EAttribute)feature;
            return RuleService.evalAffectedRenderables(this.enableRuleRegistry, EnableRule.class, (EStructuralFeature)attribute, possibleValues);
        }
        return Collections.emptyMap();
    }

    public Map<VElement, Boolean> getHiddenRenderables(Map<EStructuralFeature.Setting, Object> possibleValues) {
        EStructuralFeature feature = possibleValues.keySet().iterator().next().getEStructuralFeature();
        if (feature instanceof EAttribute) {
            EAttribute attribute = (EAttribute)feature;
            return RuleService.evalAffectedRenderables(this.showRuleRegistry, ShowRule.class, (EStructuralFeature)attribute, possibleValues);
        }
        return Collections.emptyMap();
    }

    private void unset(VElement renderable) {
        if (renderable instanceof VControl) {
            VControl control = (VControl)renderable;
            VDomainModelReference domainModelReference = control.getDomainModelReference();
            Iterator settings = domainModelReference.getIterator();
            while (settings.hasNext()) {
                EStructuralFeature.Setting setting = (EStructuralFeature.Setting)settings.next();
                EObject parent = setting.getEObject();
                EStructuralFeature targetFeature = setting.getEStructuralFeature();
                if (targetFeature == null) continue;
                Class containerClass = targetFeature.getContainerClass();
                this.isUnset = true;
                if (containerClass.isInstance(parent)) {
                    parent.eUnset(targetFeature);
                }
                this.isUnset = false;
            }
        }
    }

    public void dispose() {
        this.context.unregisterDomainChangeListener(this.domainChangeListener);
        this.context.unregisterViewChangeListener(this.viewChangeListener);
    }

    private static boolean isEnableRule(Rule rule) {
        return EnableRule.class.isInstance(rule);
    }

    private static boolean isAttributeNotification(ModelChangeNotification notification) {
        return notification.getStructuralFeature() instanceof EAttribute;
    }

    private boolean isMultiRefNotification(ModelChangeNotification notification) {
        if (EReference.class.isInstance(notification.getStructuralFeature())) {
            EReference reference = (EReference)notification.getStructuralFeature();
            return reference.getUpperBound() < 0 || reference.getUpperBound() > 1;
        }
        return false;
    }

    public int getPriority() {
        return 1;
    }
}

