/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.view.context.AbstractViewService;
import org.eclipse.emf.ecp.view.context.ModelChangeNotification;
import org.eclipse.emf.ecp.view.context.ViewModelContext;
import org.eclipse.emf.ecp.view.model.VControl;
import org.eclipse.emf.ecp.view.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.model.VElement;
import org.eclipse.emf.ecp.view.model.VViewPackage;
import org.eclipse.emf.ecp.view.validation.ValidationRegistry;
import org.eclipse.emf.ecp.view.validation.ViewValidationListener;
import org.eclipse.emf.ecp.view.validation.ViewValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationService
extends AbstractViewService {
    private ViewModelContext context;
    private VElement renderable;
    private ViewModelContext.ModelChangeListener domainChangeListener;
    private ViewModelContext.ModelChangeListener viewChangeListener;
    private ViewValidator viewValidationGraph;
    private ValidationRegistry validationRegistry;
    private final List<ViewValidationListener> validationListener = new ArrayList<ViewValidationListener>();

    public void instantiate(ViewModelContext context) {
        this.context = context;
        this.renderable = context.getViewModel();
        if (this.renderable == null) {
            throw new IllegalStateException("View model must not be null");
        }
        EObject domainModel = context.getDomainModel();
        if (domainModel == null) {
            throw new IllegalStateException("Domain model must not be null");
        }
        this.domainChangeListener = new DomainModelChangeListener(domainModel);
        this.viewChangeListener = new ViewModelChangeListener(domainModel);
        context.registerDomainChangeListener(this.domainChangeListener);
        context.registerViewChangeListener(this.viewChangeListener);
        this.init(this.renderable, domainModel);
        this.viewValidationGraph.validate(this.getAllEObjects(domainModel));
        this.notifyListeners();
    }

    private void init(VElement view, EObject domainModel) {
        this.validationRegistry = new ValidationRegistry();
        this.validationRegistry.register(domainModel, view);
        this.viewValidationGraph = new ViewValidator(view, domainModel, this.validationRegistry);
    }

    private Collection<EObject> getAllEObjects(EObject eObject) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        result.add(eObject);
        TreeIterator iterator = EcoreUtil.getAllContents((EObject)eObject, (boolean)false);
        while (iterator.hasNext()) {
            result.add((EObject)iterator.next());
        }
        return result;
    }

    public void registerValidationListener(ViewValidationListener listener) {
        this.validationListener.add(listener);
        listener.onNewValidation(this.getDiagnosticResult());
    }

    public void deregisterValidationListener(ViewValidationListener listener) {
        this.validationListener.remove(listener);
    }

    private void notifyListeners() {
        if (this.validationListener.size() > 0) {
            Set<Diagnostic> result = this.getDiagnosticResult();
            for (ViewValidationListener l : this.validationListener) {
                l.onNewValidation(result);
            }
        }
    }

    private Set<Diagnostic> getDiagnosticResult() {
        LinkedHashSet<Diagnostic> result = new LinkedHashSet<Diagnostic>();
        if (this.renderable.getDiagnostic().getHighestSeverity() > 0) {
            for (Object o : this.renderable.getDiagnostic().getDiagnostics()) {
                if (((Diagnostic)o).getSeverity() <= 0) continue;
                result.add((Diagnostic)o);
            }
        }
        return result;
    }

    public void dispose() {
        this.context.unregisterDomainChangeListener(this.domainChangeListener);
        this.context.unregisterViewChangeListener(this.viewChangeListener);
    }

    public int getPriority() {
        return 3;
    }

    class DomainModelChangeListener
    implements ViewModelContext.ModelChangeListener {
        private final EObject domainModel;

        public DomainModelChangeListener(EObject domainModel) {
            this.domainModel = domainModel;
        }

        public void notifyChange(ModelChangeNotification notification) {
            if (ValidationService.this.viewValidationGraph == null) {
                return;
            }
            Notification rawNotification = notification.getRawNotification();
            switch (rawNotification.getEventType()) {
                case 3: 
                case 4: {
                    ValidationService.this.viewValidationGraph.validate(ValidationService.this.getAllEObjects(notification.getNotifier()));
                    break;
                }
                case 5: 
                case 6: {
                    ValidationService.this.viewValidationGraph.validate(ValidationService.this.getAllEObjects(this.domainModel));
                    break;
                }
                default: {
                    ValidationService.this.viewValidationGraph.validate(ValidationService.this.getAllEObjects(notification.getNotifier()));
                }
            }
            ValidationService.this.notifyListeners();
        }

        public void notifyAdd(Notifier notifier) {
            if (ValidationService.this.viewValidationGraph != null) {
                ValidationService.this.viewValidationGraph.validate((EObject)notifier);
            }
        }

        public void notifyRemove(Notifier notifier) {
            EObject eObject = (EObject)notifier;
            ValidationService.this.viewValidationGraph.removeDomainObject(eObject);
            ValidationService.this.validationRegistry.removeDomainObject(eObject);
        }
    }

    class ViewModelChangeListener
    implements ViewModelContext.ModelChangeListener {
        private final EObject domainModel;

        public ViewModelChangeListener(EObject domainModel) {
            this.domainModel = domainModel;
        }

        public void notifyChange(ModelChangeNotification notification) {
            if (!(!VElement.class.isInstance(notification.getRawNotification().getNotifier()) || notification.getRawNotification().getFeature() == VViewPackage.eINSTANCE.getElement_Diagnostic() || EReference.class.isInstance(notification.getRawNotification().getFeature()) && VElement.class.isInstance(notification.getRawNotification().getNewValue()) || VViewPackage.eINSTANCE.getElement_Enabled() != notification.getRawNotification().getFeature() && VViewPackage.eINSTANCE.getElement_Visible() != notification.getRawNotification().getFeature() || VViewPackage.eINSTANCE.getControl() != notification.getNotifier().eClass())) {
                VControl control = (VControl)notification.getNotifier();
                VDomainModelReference domainModelReference = control.getDomainModelReference();
                Iterator settings = domainModelReference.getIterator();
                while (settings.hasNext()) {
                    ValidationService.this.viewValidationGraph.validate(((EStructuralFeature.Setting)settings.next()).getEObject());
                }
            }
        }

        public void notifyAdd(Notifier notifier) {
            VElement renderable;
            EObject renderableParent;
            if (VElement.class.isInstance(notifier) && VElement.class.isInstance(renderableParent = (renderable = (VElement)notifier).eContainer()) && ValidationService.this.validationRegistry.containsRenderable((VElement)renderableParent)) {
                ValidationService.this.validationRegistry.register(this.domainModel, renderable);
                Map<EObject, Set<VControl>> map = ValidationService.this.validationRegistry.getDomainToControlMapping(this.domainModel, renderable);
                ValidationService.this.viewValidationGraph.validate(map.keySet());
            }
        }

        public void notifyRemove(Notifier notifier) {
            if (VElement.class.isInstance(notifier)) {
                ValidationService.this.validationRegistry.removeRenderable((VElement)notifier);
                ValidationService.this.viewValidationGraph.removeRenderable((VElement)notifier);
            }
        }
    }
}

