/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.validation;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.PriorityQueue;
import java.util.Set;
import org.eclipse.emf.ecp.common.UniqueSetting;
import org.eclipse.emf.ecp.view.model.VElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewModelGraphNode<T> {
    private T initValue;
    private Set<ViewModelGraphNode<T>> parents;
    private final UniqueSetting setting;
    private final PriorityQueue<ViewModelGraphNode<T>> children;
    private final boolean isDomainObject;
    private T value;

    public ViewModelGraphNode(UniqueSetting setting, T value, boolean isDomainObject, final Comparator<T> comparator) {
        this.setting = setting;
        this.value = value;
        this.initValue = value;
        this.isDomainObject = isDomainObject;
        this.parents = new LinkedHashSet<ViewModelGraphNode<T>>();
        this.children = new PriorityQueue(10, new Comparator<ViewModelGraphNode<T>>(){

            @Override
            public int compare(ViewModelGraphNode<T> node1, ViewModelGraphNode<T> node2) {
                Object node1Value = node1.getValue();
                Object node2Value = node2.getValue();
                return -comparator.compare(node1Value, node2Value);
            }
        });
    }

    public T getValue() {
        if (this.isLocked()) {
            return this.initValue;
        }
        if (this.hasChildren()) {
            return ((ViewModelGraphNode)this.children.element()).getValue();
        }
        return this.value;
    }

    public boolean isLocked() {
        VElement renderable;
        return this.isRenderable() && (!(renderable = (VElement)this.getSetting().getEObject()).isEnabled() || !renderable.isVisible() || renderable.isReadonly());
    }

    private boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public void addChild(ViewModelGraphNode<T> childNode) {
        super.addParent(this);
        this.addToChildrenQueue(childNode);
    }

    public void removeChild(ViewModelGraphNode<T> childNode) {
        this.children.remove(childNode);
        childNode.getParents().remove(this);
        if (!this.hasChildren()) {
            this.value = this.initValue;
        }
    }

    public void setValue(T value) {
        this.value = value;
        for (ViewModelGraphNode<T> parent : this.getParents()) {
            super.addToChildrenQueue(this);
            parent.setValue(parent.getValue());
        }
    }

    public Set<ViewModelGraphNode<T>> getParents() {
        return this.parents;
    }

    private void addParent(ViewModelGraphNode<T> parent) {
        this.parents.add(parent);
    }

    private void addToChildrenQueue(ViewModelGraphNode<T> childNode) {
        this.children.remove(childNode);
        this.children.add(childNode);
    }

    public boolean isDomainObject() {
        return this.isDomainObject;
    }

    public boolean isRenderable() {
        return !this.isDomainObject && VElement.class.isInstance(this.getSetting().getEObject());
    }

    public boolean containsChild(ViewModelGraphNode<T> node) {
        return this.children.contains(node);
    }

    public UniqueSetting getSetting() {
        return this.setting;
    }

    public Iterator<ViewModelGraphNode<T>> getChildren() {
        return this.children.iterator();
    }
}

