/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.core.util.observer.ECPObserver;
import org.eclipse.emf.ecp.internal.core.Activator;
import org.eclipse.emf.ecp.spi.core.util.ECPDisposable;
import org.eclipse.net4j.util.lifecycle.Lifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Registry<ELEMENT, OBSERVER extends ECPObserver>
extends Lifecycle
implements ECPDisposable.DisposeListener {
    private static final ThreadLocal<Boolean> DISPOSING_ELEMENT = new InheritableThreadLocal<Boolean>();
    private final Map<String, ELEMENT> elements = new HashMap<String, ELEMENT>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ELEMENT getElement(String key) {
        this.checkActive();
        Registry registry = this;
        synchronized (registry) {
            return this.elements.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Set<String> getElementNames() {
        this.checkActive();
        Registry registry = this;
        synchronized (registry) {
            return Collections.unmodifiableSet(new HashSet<String>(this.elements.keySet()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getElementCount() {
        this.checkActive();
        Registry registry = this;
        synchronized (registry) {
            return this.elements.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Collection<ELEMENT> getElements() {
        this.checkActive();
        Registry registry = this;
        synchronized (registry) {
            return Collections.unmodifiableCollection(new ArrayList<ELEMENT>(this.elements.values()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasElements() {
        this.checkActive();
        Registry registry = this;
        synchronized (registry) {
            return !this.elements.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasElement(String name) {
        this.checkActive();
        Registry registry = this;
        synchronized (registry) {
            return this.elements.containsKey(name);
        }
    }

    public final void changeElements(Set<String> remove, Set<ELEMENT> add) {
        this.checkActive();
        this.doChangeElements(remove, add);
    }

    @Override
    public final void disposed(ECPDisposable disposable) {
        String name;
        if (this.isRemoveDisposedElements() && (name = this.getElementName(disposable)) != null) {
            try {
                DISPOSING_ELEMENT.set(true);
                this.doChangeElements(Collections.singleton(name), null);
            }
            finally {
                DISPOSING_ELEMENT.remove();
            }
        }
    }

    protected boolean isRemoveDisposedElements() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Set<ELEMENT> doChangeElements(Set<String> remove, Set<ELEMENT> add) {
        HashSet<ELEMENT> result = null;
        HashSet<ELEMENT> oldElements = new HashSet<ELEMENT>();
        HashSet<ELEMENT> newElements = null;
        Registry registry = this;
        synchronized (registry) {
            ECPDisposable disposable;
            oldElements.addAll(this.elements.values());
            if (remove != null) {
                for (String name : remove) {
                    ELEMENT element = this.elements.remove(name);
                    if (element == null) continue;
                    if (element instanceof ECPDisposable) {
                        disposable = (ECPDisposable)element;
                        disposable.removeDisposeListener(this);
                    }
                    if (result == null) {
                        result = new HashSet<ELEMENT>();
                    }
                    result.add(element);
                }
            }
            if (add != null) {
                for (Object element : add) {
                    String name = this.getElementName(element);
                    this.elements.put(name, element);
                    if (!(element instanceof ECPDisposable)) continue;
                    disposable = (ECPDisposable)element;
                    disposable.addDisposeListener(this);
                }
            }
            if (!oldElements.equals(this.elements)) {
                newElements = new HashSet<ELEMENT>(this.elements.values());
            }
        }
        if (newElements != null) {
            Collection unmodifiableOld = Collections.unmodifiableCollection(oldElements);
            Collection<ELEMENT> unmodifiableNew = Collections.unmodifiableCollection(newElements);
            this.elementsChanged(unmodifiableOld, unmodifiableNew);
            try {
                this.notifyObservers(unmodifiableOld, unmodifiableNew);
            }
            catch (Exception ex) {
                Activator.log(ex);
            }
        }
        return result;
    }

    public void addObserver(OBSERVER observer) {
        ECPUtil.getECPObserverBus().register((ECPObserver)observer);
    }

    public void removeObserver(OBSERVER observer) {
        ECPUtil.getECPObserverBus().unregister((ECPObserver)observer);
    }

    protected abstract void notifyObservers(Collection<ELEMENT> var1, Collection<ELEMENT> var2) throws Exception;

    protected void elementsChanged(Collection<ELEMENT> oldElements, Collection<ELEMENT> newElements) {
    }

    protected abstract String getElementName(ELEMENT var1);

    protected static boolean isDisposingElement() {
        Boolean disposingElement = DISPOSING_ELEMENT.get();
        return disposingElement != null && disposingElement != false;
    }
}

