/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.internal.swt.actions;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.internal.swt.Activator;
import org.eclipse.emf.ecp.edit.internal.swt.actions.ActionMessages;
import org.eclipse.emf.ecp.edit.internal.swt.actions.ECPSWTAction;
import org.eclipse.emf.ecp.edit.spi.ECPControlContext;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.jface.dialogs.MessageDialog;

public class DeleteReferenceAction
extends ECPSWTAction {
    public DeleteReferenceAction(ECPControlContext modelElementContext, IItemPropertyDescriptor itemPropertyDescriptor, EStructuralFeature feature) {
        super(modelElementContext, itemPropertyDescriptor, feature);
        this.setImageDescriptor(Activator.getImageDescriptor("icons/delete.png"));
        this.setToolTipText(ActionMessages.DeleteReferenceAction_DeleteReference);
    }

    public void run() {
        super.run();
        EReference reference = (EReference)this.getFeature();
        if (reference.isContainment()) {
            if (DeleteReferenceAction.askConfirmation((EObject)this.getModelElementContext().getModelElement().eGet((EStructuralFeature)reference))) {
                this.delete(reference);
            }
        } else {
            this.delete(reference);
        }
    }

    private void delete(EReference reference) {
        Command removeCommand = null;
        removeCommand = reference.isMany() ? RemoveCommand.create((EditingDomain)this.getModelElementContext().getEditingDomain(), (Object)this.getModelElementContext().getModelElement(), (Object)reference, (Object)this.getModelElementContext().getModelElement().eGet(this.getFeature())) : SetCommand.create((EditingDomain)this.getModelElementContext().getEditingDomain(), (Object)this.getModelElementContext().getModelElement(), (Object)reference, null);
        this.getModelElementContext().getEditingDomain().getCommandStack().execute(removeCommand);
    }

    private static boolean askConfirmation(EObject toBeDeleted) {
        String question = null;
        ComposedAdapterFactory adapterFactory = null;
        adapterFactory = new ComposedAdapterFactory(new AdapterFactory[]{new ReflectiveItemProviderAdapterFactory(), new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE)});
        AdapterFactoryItemDelegator adapterFactoryItemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)adapterFactory);
        String modelElementName = adapterFactoryItemDelegator.getText((Object)toBeDeleted);
        question = String.valueOf(ActionMessages.DeleteReferenceAction_DeleteModelQuestion) + modelElementName + ActionMessages.DeleteReferenceAction_Questionmark;
        MessageDialog dialog = new MessageDialog(null, ActionMessages.DeleteReferenceAction_Confirmation, null, question, 3, new String[]{ActionMessages.DeleteReferenceAction_Yes, ActionMessages.DeleteReferenceAction_No}, 0);
        boolean confirm = false;
        if (dialog.open() == 0) {
            confirm = true;
        }
        adapterFactory.dispose();
        return confirm;
    }
}

