/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.internal.swt.controls;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.ecp.edit.internal.swt.controls.ControlMessages;
import org.eclipse.emf.ecp.edit.internal.swt.controls.SingleControl;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolTip;

public abstract class AbstractTextControl
extends SingleControl {
    private Text text;
    private boolean doVerify;

    protected void updateValidationColor(Color color) {
        this.text.setBackground(color);
    }

    protected void fillControlComposite(Composite composite) {
        this.doVerify = false;
        this.createTextWidget(composite);
        this.addControlDecoration((Control)this.text);
    }

    private void createTextWidget(Composite composite) {
        this.text = new Text(composite, this.getTextWidgetStyle());
        this.text.setLayoutData((Object)this.getTextWidgetLayoutData());
        if (this.getStructuralFeature().isUnsettable()) {
            this.text.setMessage(ControlMessages.AbstractTextControl_Unset);
        }
        this.text.setData("org.eclipse.rap.rwt.customVariant", (Object)this.getTextVariantID());
        this.customizeText(this.text);
    }

    protected ToolTip createToolTip(int style, String text, String message) {
        ToolTip toolTip = new ToolTip(this.text.getShell(), style);
        toolTip.setText(text);
        toolTip.setMessage(message);
        return toolTip;
    }

    protected void customizeText(Text text) {
    }

    protected abstract String getTextVariantID();

    protected GridData getTextWidgetLayoutData() {
        return new GridData(4, 4, true, true);
    }

    protected int getTextWidgetStyle() {
        return 2052;
    }

    protected Control[] getControlsForTooltip() {
        return new Control[]{this.text};
    }

    public void setEditable(boolean isEditable) {
        this.text.setEditable(isEditable);
    }

    public Binding bindValue() {
        ISWTObservableValue value = SWTObservables.observeText((Control)this.text, (int)16);
        Binding binding = this.getDataBindingContext().bindValue((IObservableValue)value, this.getModelValue(), (UpdateValueStrategy)new TargetToModelUpdateStrategy(), (UpdateValueStrategy)new ModelToTargetUpdateStrategy());
        return binding;
    }

    protected void setUnvalidatedString(String string) {
        boolean oldDoVerify = this.doVerify;
        this.doVerify = false;
        this.text.setText(string);
        this.doVerify = oldDoVerify;
    }

    public void dispose() {
        this.text.dispose();
        super.dispose();
    }

    public Text getText() {
        return this.text;
    }

    class EMFUpdateConvertValueStrategy
    extends EMFUpdateValueStrategy {
        public Object convert(Object value) {
            return this.convertValue(value);
        }

        protected Object convertValue(Object value) {
            return super.convert(value);
        }
    }

    protected class ModelToTargetUpdateStrategy
    extends EMFUpdateConvertValueStrategy {
        protected ModelToTargetUpdateStrategy() {
        }

        public Object convert(Object value) {
            AbstractTextControl.this.updateValidationColor(null);
            return this.convertValue(value);
        }
    }

    protected class TargetToModelUpdateStrategy
    extends EMFUpdateConvertValueStrategy {
        protected TargetToModelUpdateStrategy() {
        }

        public IStatus validateAfterGet(Object value) {
            IStatus status = super.validateAfterGet(value);
            return status;
        }

        public Object convert(Object value) {
            try {
                AbstractTextControl.this.updateValidationColor(null);
                if ("".equals(value)) {
                    value = null;
                }
                if (value == null && AbstractTextControl.this.getStructuralFeature().isUnsettable()) {
                    return SetCommand.UNSET_VALUE;
                }
                Object convertedValue = this.convertValue(value);
                return convertedValue;
            }
            catch (IllegalArgumentException e) {
                AbstractTextControl.this.updateValidationColor(AbstractTextControl.this.getText().getShell().getDisplay().getSystemColor(3));
                throw e;
            }
        }
    }
}

