/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.internal.swt.controls;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.databinding.edit.EMFEditObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.internal.swt.Activator;
import org.eclipse.emf.ecp.edit.internal.swt.actions.ECPSWTAction;
import org.eclipse.emf.ecp.edit.internal.swt.util.ECPObservableValue;
import org.eclipse.emf.ecp.edit.internal.swt.util.SWTControl;
import org.eclipse.emf.ecp.edit.spi.ECPControlDescription;
import org.eclipse.emf.ecp.edit.spi.ECPControlFactory;
import org.eclipse.emf.ecp.edit.spi.util.ECPApplicableTester;
import org.eclipse.emf.ecp.edit.spi.util.ECPStaticApplicableTester;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public abstract class MultiControl
extends SWTControl {
    private static final String ICONS_ARROW_DOWN_PNG = "icons/arrow_down.png";
    private static final String ICONS_ARROW_UP_PNG = "icons/arrow_up.png";
    private IObservableList model;
    private IListChangeListener changeListener;
    private final List<WidgetWrapper> widgetWrappers = new ArrayList<WidgetWrapper>();
    private final List<ECPSWTAction> toolBarActions = new ArrayList<ECPSWTAction>();
    private Composite mainComposite;
    private Composite sectionComposite;
    private ECPControlDescription controlDescription;
    private Class<?> supportedClassType;
    private ECPSWTAction[] actions;
    private Button unsetButton;
    private Label tooltipLabel;

    protected abstract ECPSWTAction[] instantiateActions();

    private void findControlDescription(IItemPropertyDescriptor itemPropertyDescriptor, EObject eObject) {
        int bestPriority = -1;
        ECPControlFactory controlFactory = Activator.getDefault().getECPControlFactory();
        if (controlFactory == null) {
            Activator.getDefault().ungetECPControlFactory();
            return;
        }
        for (ECPControlDescription description : controlFactory.getControlDescriptors()) {
            for (ECPApplicableTester tester : description.getTester()) {
                ECPStaticApplicableTester test;
                int priority;
                if (!ECPStaticApplicableTester.class.isInstance(tester) || bestPriority >= (priority = this.getTesterPriority(test = (ECPStaticApplicableTester)tester, itemPropertyDescriptor, eObject))) continue;
                bestPriority = priority;
                this.controlDescription = description;
                this.supportedClassType = test.getSupportedClassType();
            }
        }
        Activator.getDefault().ungetECPControlFactory();
    }

    protected abstract int getTesterPriority(ECPStaticApplicableTester var1, IItemPropertyDescriptor var2, EObject var3);

    protected void fillControlComposite(Composite parent) {
        this.findControlDescription(this.getItemPropertyDescriptor(), this.getModelElementContext().getModelElement());
        this.actions = this.instantiateActions();
        this.mainComposite = new Composite(parent, 2048);
        this.mainComposite.setBackground(parent.getBackground());
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)this.mainComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).applyTo(this.mainComposite);
        this.createButtonBar();
        Label seperator = new Label(this.mainComposite, 258);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).span(3, 1).applyTo((Control)seperator);
        this.model = EMFEditObservables.observeList((EditingDomain)this.getModelElementContext().getEditingDomain(), (EObject)this.getModelElementContext().getModelElement(), (EStructuralFeature)this.getStructuralFeature());
        final ScrolledComposite scrolledComposite = new ScrolledComposite(this.mainComposite, 512);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).hint(-1, 150).minSize(-1, 150).span(3, 1).applyTo((Control)scrolledComposite);
        this.sectionComposite = new Composite((Composite)scrolledComposite, 0);
        this.sectionComposite.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(1).equalWidth(false).spacing(0, 5).applyTo(this.sectionComposite);
        this.changeListener = new IListChangeListener(){

            public void handleListChange(ListChangeEvent event) {
                ListDiff diff = event.diff;
                diff.accept(new ListDiffVisitor(){
                    int widthBeforeChange = -1;

                    public void handleRemove(int index, Object element) {
                        MultiControl.this.updateIndicesAfterRemove(index);
                        this.triggerScrollbarUpdate();
                        this.updateTargets();
                    }

                    private void updateTargets() {
                        for (WidgetWrapper widgetWrapper : MultiControl.this.widgetWrappers) {
                            widgetWrapper.widget.getDataBindingContext().updateTargets();
                        }
                    }

                    public void handleAdd(int index, Object element) {
                        MultiControl.this.addControl();
                        MultiControl.this.sectionComposite.layout();
                        this.triggerScrollbarUpdate();
                        this.updateTargets();
                    }

                    public void handleMove(int oldIndex, int newIndex, Object element) {
                        this.updateTargets();
                    }

                    public void handleReplace(int index, Object oldElement, Object newElement) {
                    }

                    private void triggerScrollbarUpdate() {
                        int widthAfterChange = ((MultiControl)(this).MultiControl.this).sectionComposite.getSize().x;
                        if (this.widthBeforeChange != widthAfterChange) {
                            scrolledComposite.setMinHeight(((MultiControl)(this).MultiControl.this).sectionComposite.computeSize((int)widthAfterChange, (int)-1).y);
                            this.widthBeforeChange = widthAfterChange;
                        }
                    }
                });
            }
        };
        this.model.addListChangeListener(this.changeListener);
        int i = 0;
        while (i < this.model.size()) {
            this.addControl();
            ++i;
        }
        this.refreshSection();
        scrolledComposite.setMinSize(this.sectionComposite.computeSize(-1, -1));
        scrolledComposite.setContent((Control)this.sectionComposite);
    }

    protected Button getCustomUnsetButton() {
        return this.unsetButton;
    }

    private void isFull() {
        int upperBound = this.getStructuralFeature().getUpperBound();
        boolean full = this.model.size() >= upperBound && upperBound != -1;
        for (Action action : this.toolBarActions) {
            action.setEnabled(!full);
        }
    }

    private void addControl() {
        ECPObservableValue modelValue = new ECPObservableValue(this.model, this.widgetWrappers.size(), this.supportedClassType);
        WidgetWrapper h = new WidgetWrapper(modelValue);
        h.createControl(this.sectionComposite, 0);
        this.widgetWrappers.add(h);
    }

    private SWTControl getSingleInstance() {
        try {
            Constructor widgetConstructor = this.controlDescription.getControlClass().getConstructor(new Class[0]);
            SWTControl control = (SWTControl)widgetConstructor.newInstance(new Object[0]);
            control.init(this.getModelElementContext(), this.getDomainModelReference());
            control.setEmbedded(true);
            return control;
        }
        catch (IllegalArgumentException ex) {
            Activator.logException(ex);
        }
        catch (InstantiationException ex) {
            Activator.logException(ex);
        }
        catch (IllegalAccessException ex) {
            Activator.logException(ex);
        }
        catch (InvocationTargetException ex) {
            Activator.logException(ex);
        }
        catch (SecurityException ex) {
            Activator.logException(ex);
        }
        catch (NoSuchMethodException ex) {
            Activator.logException(ex);
        }
        return null;
    }

    private void refreshSection() {
        int widgetSize = 150;
        if (this.widgetWrappers.size() > 0) {
            widgetSize = this.widgetWrappers.size() * (((WidgetWrapper)this.widgetWrappers.get((int)0)).composite.computeSize((int)-1, (int)-1).y + 5);
        }
        this.sectionComposite.setSize(this.sectionComposite.getSize().x, widgetSize < 150 ? 150 : widgetSize);
        this.sectionComposite.layout();
        this.isFull();
    }

    private void createButtonBar() {
        Composite toolbarComposite = new Composite(this.mainComposite, 0);
        toolbarComposite.setBackground(this.mainComposite.getBackground());
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)toolbarComposite);
        int colNum = this.actions.length + 1;
        if (!this.isEmbedded() && this.getStructuralFeature().isUnsettable()) {
            ++colNum;
        }
        GridLayoutFactory.fillDefaults().numColumns(colNum).equalWidth(false).applyTo(toolbarComposite);
        this.tooltipLabel = new Label(toolbarComposite, 0);
        this.tooltipLabel.setBackground(this.mainComposite.getBackground());
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)this.tooltipLabel);
        ECPSWTAction[] eCPSWTActionArray = this.actions;
        int n = this.actions.length;
        int n2 = 0;
        while (n2 < n) {
            ECPSWTAction action = eCPSWTActionArray[n2];
            action.setEnabled(this.isEditable());
            this.createButtonForAction(action, toolbarComposite);
            ++n2;
        }
        if (!this.isEmbedded() && this.getStructuralFeature().isUnsettable()) {
            this.unsetButton = new Button(toolbarComposite, 8);
            this.unsetButton.setToolTipText(this.getUnsetButtonTooltip());
            this.unsetButton.setImage(Activator.getImage("icons/delete.png"));
        }
    }

    private void updateIndicesAfterRemove(int indexRemoved) {
        WidgetWrapper wrapper = this.widgetWrappers.remove(this.widgetWrappers.size() - 1);
        wrapper.composite.dispose();
    }

    public void handleValidation(Diagnostic diagnostic) {
        if (this.validationLabel == null) {
            return;
        }
        if (diagnostic.getSeverity() == 4 || diagnostic.getSeverity() == 2) {
            Image image = Activator.getImage("icons/validation_error.png");
            this.validationLabel.setImage(image);
            this.validationLabel.setToolTipText(diagnostic.getMessage());
        }
    }

    public void resetValidation() {
        if (this.validationLabel == null || this.validationLabel.isDisposed()) {
            return;
        }
        this.validationLabel.setImage(null);
    }

    public void dispose() {
        this.model.removeListChangeListener(this.changeListener);
        this.model.dispose();
        for (WidgetWrapper helper : this.widgetWrappers) {
            helper.dispose();
        }
        this.mainComposite.dispose();
    }

    public Binding bindValue() {
        return null;
    }

    public void setEditable(boolean isEditable) {
        ECPSWTAction[] eCPSWTActionArray = this.actions;
        int n = this.actions.length;
        int n2 = 0;
        while (n2 < n) {
            ECPSWTAction action = eCPSWTActionArray[n2];
            action.setEnabled(isEditable);
            ++n2;
        }
    }

    protected Control[] getControlsForTooltip() {
        return new Control[]{this.tooltipLabel};
    }

    @Deprecated
    public boolean showLabel() {
        return true;
    }

    private final class WidgetWrapper {
        private ECPObservableValue modelValue;
        private Composite composite;
        private SWTControl widget;

        public WidgetWrapper(ECPObservableValue modelValue) {
            this.modelValue = modelValue;
        }

        private WidgetWrapper getThis() {
            return this;
        }

        void createControl(Composite parent, int style) {
            this.composite = new Composite(parent, style);
            this.composite.setBackgroundMode(2);
            this.composite.setBackground(parent.getBackground());
            GridLayoutFactory.fillDefaults().numColumns(4).spacing(2, 0).applyTo(this.composite);
            GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)this.composite);
            this.widget = MultiControl.this.getSingleInstance();
            this.widget.setObservableValue((IObservableValue)this.modelValue);
            Composite createControl = this.widget.createControl(this.composite);
            GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)createControl);
            this.createDeleteButton(this.composite);
            if (MultiControl.this.getStructuralFeature().isOrdered()) {
                this.createUpDownButtons(this.composite);
            }
        }

        private void createDeleteButton(Composite composite) {
            Button delB = new Button(composite, 8);
            delB.setImage(Activator.getImage("icons/delete.png"));
            delB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MultiControl.this.getModelElementContext().getEditingDomain().getCommandStack().execute(RemoveCommand.create((EditingDomain)MultiControl.this.getModelElementContext().getEditingDomain(), (Object)MultiControl.this.getModelElementContext().getModelElement(), (Object)MultiControl.this.getStructuralFeature(), (Object)WidgetWrapper.this.modelValue.getValue()));
                }
            });
        }

        private void createUpDownButtons(Composite composite) {
            Image up = Activator.getImage(MultiControl.ICONS_ARROW_UP_PNG);
            Image down = Activator.getImage(MultiControl.ICONS_ARROW_DOWN_PNG);
            Button upB = new Button(composite, 8);
            upB.setImage(up);
            upB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (WidgetWrapper.this.getThis().getModelValue().getIndex() == 0) {
                        return;
                    }
                    int currentIndex = WidgetWrapper.this.getThis().getModelValue().getIndex();
                    MultiControl.this.getModelElementContext().getEditingDomain().getCommandStack().execute((Command)new MoveCommand(MultiControl.this.getModelElementContext().getEditingDomain(), MultiControl.this.getModelElementContext().getModelElement(), MultiControl.this.getStructuralFeature(), currentIndex, currentIndex - 1));
                }
            });
            Button downB = new Button(composite, 8);
            downB.setImage(down);
            downB.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (WidgetWrapper.this.getThis().getModelValue().getIndex() + 1 == MultiControl.this.model.size()) {
                        return;
                    }
                    int currentIndex = WidgetWrapper.this.getThis().getModelValue().getIndex();
                    MultiControl.this.getModelElementContext().getEditingDomain().getCommandStack().execute((Command)new MoveCommand(MultiControl.this.getModelElementContext().getEditingDomain(), MultiControl.this.getModelElementContext().getModelElement(), MultiControl.this.getStructuralFeature(), currentIndex, currentIndex + 1));
                }
            });
        }

        ECPObservableValue getModelValue() {
            return this.modelValue;
        }

        public void dispose() {
            this.composite.dispose();
            this.modelValue.dispose();
            this.composite = null;
            this.modelValue = null;
            this.widget = null;
        }
    }
}

