/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.internal.swt.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.edit.EMFEditObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.internal.swt.Activator;
import org.eclipse.emf.ecp.edit.internal.swt.util.ECPControlSWT;
import org.eclipse.emf.ecp.edit.internal.swt.util.ECPDialogExecutor;
import org.eclipse.emf.ecp.edit.internal.swt.util.SWTRenderingHelper;
import org.eclipse.emf.ecp.edit.internal.swt.util.UtilMessages;
import org.eclipse.emf.ecp.edit.spi.ECPAbstractControl;
import org.eclipse.emf.ecp.internal.ui.view.renderer.RenderingResultRow;
import org.eclipse.emf.ecp.view.model.VDomainModelReference;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SWTControl
extends ECPAbstractControl
implements ECPControlSWT {
    protected static final String CUSTOM_VARIANT = "org.eclipse.rap.rwt.customVariant";
    protected static final String VALIDATION_ERROR_ICON = "icons/validation_error.png";
    protected Label validationLabel;
    private IObservableValue modelValue;
    private Binding binding;
    private Composite controlComposite;
    private Composite parentComposite;
    private StackLayout sl;
    private Label unsetLabel;

    @Override
    public List<RenderingResultRow<Control>> createControls(Composite parent) {
        IItemPropertyDescriptor itemPropertyDescriptor = this.getItemPropertyDescriptor();
        if (itemPropertyDescriptor == null) {
            return null;
        }
        return Collections.singletonList(SWTRenderingHelper.INSTANCE.getResultRowFactory().createRenderingResultRow((Object[])new Control[]{this.createControl(parent)}));
    }

    public Composite createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        int numColumns = 2;
        if (this.isEmbedded()) {
            --numColumns;
        }
        if (this.getModelElementContext().isRunningAsWebApplication()) {
            ++numColumns;
        }
        GridLayoutFactory.fillDefaults().numColumns(numColumns).applyTo(composite);
        this.createValidationIcon(composite);
        this.createDataControl(composite);
        this.createHelpIcon(composite);
        this.setEditable(this.isEditable());
        this.binding = this.bindValue();
        if (!this.getStructuralFeature().isUnsettable() && !this.getModelElementContext().getModelElement().eIsSet(this.getStructuralFeature()) && this.binding != null) {
            this.binding.updateTargetToModel();
        }
        return composite;
    }

    private void createValidationIcon(Composite composite) {
        if (!this.isEmbedded()) {
            this.validationLabel = new Label(composite, 0);
            this.validationLabel.setBackground(composite.getBackground());
            GridDataFactory.fillDefaults().hint(16, 17).applyTo((Control)this.validationLabel);
        }
    }

    private void createDataControl(Composite composite) {
        Composite innerComposite = new Composite(composite, 0);
        innerComposite.setBackground(composite.getBackground());
        GridDataFactory.fillDefaults().grab(true, false).align(4, 1).applyTo((Control)innerComposite);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(innerComposite);
        this.createContentControl(innerComposite);
    }

    private void createHelpIcon(final Composite composite) {
        if (this.getModelElementContext().isRunningAsWebApplication() && this.getHelpText() != null && this.getHelpText().length() != 0) {
            Label l = new Label(composite, 8);
            l.setImage(Activator.getImage("icons/help.png"));
            l.setData(CUSTOM_VARIANT, (Object)"org_eclipse_emf_ecp_control_help");
            l.setBackground(composite.getBackground());
            l.addMouseListener(new MouseListener(){

                public void mouseUp(MouseEvent e) {
                    MessageDialog dialog = new MessageDialog(composite.getShell(), UtilMessages.SWTControl_Help, null, SWTControl.this.getHelpText(), 2, new String[]{JFaceResources.getString((String)"ok")}, 0);
                    new ECPDialogExecutor((Dialog)dialog){

                        public void handleResult(int codeResult) {
                        }
                    }.execute();
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseDoubleClick(MouseEvent e) {
                }
            });
        } else {
            Control[] controls = this.getControlsForTooltip();
            if (controls != null) {
                Control[] controlArray = controls;
                int n = controls.length;
                int n2 = 0;
                while (n2 < n) {
                    Control control = controlArray[n2];
                    control.setToolTipText(this.getHelpText());
                    ++n2;
                }
            }
        }
    }

    protected abstract Control[] getControlsForTooltip();

    protected void createContentControl(Composite composite) {
        this.parentComposite = new Composite(composite, 0);
        this.parentComposite.setBackground(composite.getBackground());
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)this.parentComposite);
        this.sl = new StackLayout();
        this.parentComposite.setLayout((Layout)this.sl);
        this.controlComposite = new Composite(this.parentComposite, 0);
        this.controlComposite.setBackground(this.parentComposite.getBackground());
        this.unsetLabel = new Label(this.parentComposite, 0);
        this.unsetLabel.setBackground(composite.getBackground());
        this.unsetLabel.setForeground(composite.getShell().getDisplay().getSystemColor(16));
        this.unsetLabel.setAlignment(0x1000000);
        this.unsetLabel.setText(this.getUnsetLabelText());
        this.unsetLabel.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                ((SWTControl)SWTControl.this).sl.topControl = SWTControl.this.controlComposite;
                SWTControl.this.parentComposite.layout(true);
                if (SWTControl.this.binding != null) {
                    SWTControl.this.binding.updateTargetToModel();
                } else {
                    Object currentUnsetValue = SWTControl.this.getModelElementContext().getModelElement().eGet(SWTControl.this.getStructuralFeature());
                    SWTControl.this.getModelElementContext().getModelElement().eSet(SWTControl.this.getStructuralFeature(), currentUnsetValue);
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        int numControls = 1;
        this.fillControlComposite(this.controlComposite);
        if (!this.isEmbedded() && this.getStructuralFeature().isUnsettable()) {
            Button unsetButton = this.getCustomUnsetButton();
            if (unsetButton == null) {
                ++numControls;
                unsetButton = new Button(this.controlComposite, 8);
                unsetButton.setToolTipText(this.getUnsetButtonTooltip());
                unsetButton.setImage(Activator.getImage("icons/delete.png"));
            }
            unsetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SWTControl.this.getModelElementContext().getEditingDomain().getCommandStack().execute((Command)new SetCommand(SWTControl.this.getModelElementContext().getEditingDomain(), SWTControl.this.getModelElementContext().getModelElement(), SWTControl.this.getStructuralFeature(), SetCommand.UNSET_VALUE));
                    SWTControl.this.showUnsetLabel();
                }
            });
            unsetButton.setData(CUSTOM_VARIANT, (Object)"org_eclipse_emf_ecp_control_unset");
        }
        GridLayoutFactory.fillDefaults().numColumns(numControls).spacing(2, 0).applyTo(this.controlComposite);
        this.sl.topControl = !this.getStructuralFeature().isUnsettable() || this.getModelElementContext().getModelElement().eIsSet(this.getStructuralFeature()) ? this.controlComposite : this.unsetLabel;
        this.parentComposite.layout();
    }

    protected void showUnsetLabel() {
        this.sl.topControl = this.unsetLabel;
        this.parentComposite.layout();
    }

    protected abstract void fillControlComposite(Composite var1);

    protected Button getCustomUnsetButton() {
        return null;
    }

    protected IObservableValue getModelValue() {
        if (this.modelValue != null) {
            return this.modelValue;
        }
        this.modelValue = EMFEditObservables.observeValue((EditingDomain)this.getModelElementContext().getEditingDomain(), (EObject)this.getModelElementContext().getModelElement(), (EStructuralFeature)this.getStructuralFeature());
        return this.modelValue;
    }

    public void setObservableValue(IObservableValue modelValue) {
        this.modelValue = modelValue;
    }

    protected Button createButtonForAction(final Action action, final Composite composite) {
        Button selectButton = new Button(composite, 8);
        selectButton.setImage(action.getImageDescriptor().createImage());
        selectButton.setToolTipText(action.getToolTipText());
        selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                action.run();
                composite.layout();
            }
        });
        return selectButton;
    }

    protected abstract Binding bindValue();

    protected String getHelpText() {
        return this.getItemPropertyDescriptor().getDescription(null);
    }

    protected abstract String getUnsetLabelText();

    protected abstract String getUnsetButtonTooltip();

    protected final Color getSystemColor(int color) {
        if (this.parentComposite == null) {
            return Display.getDefault().getSystemColor(color);
        }
        return this.parentComposite.getShell().getDisplay().getSystemColor(color);
    }

    private EStructuralFeature.Setting getSetting(VDomainModelReference domainModelReference) {
        Iterator iterator = domainModelReference.getIterator();
        int count = 0;
        EStructuralFeature.Setting lastSetting = null;
        while (iterator.hasNext()) {
            if (++count == 2) {
                throw new IllegalArgumentException("The passed VDomainModelReference resolves to more then one setting.");
            }
            lastSetting = (EStructuralFeature.Setting)iterator.next();
        }
        if (count == 0) {
            throw new IllegalArgumentException("The passed VDomainModelReference resolves to no setting.");
        }
        return lastSetting;
    }

    @Deprecated
    protected EStructuralFeature getStructuralFeature() {
        Iterator iterator = this.getDomainModelReference().getEStructuralFeatureIterator();
        int count = 0;
        EStructuralFeature lastFeature = null;
        while (iterator.hasNext()) {
            ++count;
            if (lastFeature == null) {
                lastFeature = (EStructuralFeature)iterator.next();
                continue;
            }
            iterator.next();
        }
        if (count == 0) {
            throw new IllegalArgumentException("The passed VDomainModelReference resolves to no EStructuralFeature.");
        }
        return lastFeature;
    }

    @Deprecated
    protected boolean isEditable() {
        return this.getItemPropertyDescriptor().canSetProperty((Object)this.getSetting(this.getDomainModelReference()).getEObject());
    }

    @Deprecated
    protected IItemPropertyDescriptor getItemPropertyDescriptor() {
        return this.getItemPropertyDescriptor(this.getSetting(this.getDomainModelReference()));
    }
}

