/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.emfstore.internal.ui.handler;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecp.core.exceptions.ECPProjectWithNameExistsException;
import org.eclipse.emf.ecp.core.util.ECPProperties;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.emfstore.internal.ui.Activator;
import org.eclipse.emf.ecp.ui.platform.PreferenceHelper;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.ESWorkspaceProvider;
import org.eclipse.emf.emfstore.internal.client.importexport.ExportImportControllerExecutor;
import org.eclipse.emf.emfstore.internal.client.importexport.ExportImportControllerFactory;
import org.eclipse.emf.emfstore.internal.client.importexport.impl.ExportImportDataUnits;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class ImportProjectHandler
extends AbstractHandler {
    private static final String FILE_EXTENSION = ExportImportDataUnits.ProjectSpace.getExtension();
    public static final String[] FILTER_NAMES = new String[]{"Model Files (*" + FILE_EXTENSION + ")"};
    public static final String[] FILTER_EXTS = new String[]{"*" + FILE_EXTENSION};
    private static final String EXPORT_MODEL_PATH = "org.eclipse.emf.ecp.exportProjectModelPath";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        InputDialog id;
        ECPProperties properties;
        block5: {
            File file = this.getFile(HandlerUtil.getActiveShell((ExecutionEvent)event));
            if (file == null) {
                return null;
            }
            new ExportImportControllerExecutor(file, (IProgressMonitor)new NullProgressMonitor()).execute(ExportImportControllerFactory.Import.getImportProjectSpaceController());
            PreferenceHelper.setPreference((String)EXPORT_MODEL_PATH, (String)file.getParent());
            List localProjects = ESWorkspaceProvider.INSTANCE.getWorkspace().getLocalProjects();
            ESLocalProject localProject = (ESLocalProject)localProjects.get(localProjects.size() - 1);
            properties = ECPUtil.createProperties();
            properties.addProperty("projectSpaceID", localProject.getLocalProjectId().getId());
            id = new InputDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), "Project Name", "Enter the name for the imported project.", localProject.getProjectName(), new IInputValidator(){

                public String isValid(String newText) {
                    return ECPUtil.getECPProjectManager().getProject(newText) == null ? null : String.format("A project with the name %s already exists.", newText);
                }
            });
            int result = id.open();
            if (1 != result) break block5;
            return null;
        }
        try {
            String projectName = id.getValue();
            ECPUtil.getECPProjectManager().createProject(ECPUtil.getECPProviderRegistry().getProvider("org.eclipse.emf.ecp.emfstore.provider"), projectName, properties);
        }
        catch (IOException ex) {
            Activator.log(ex);
        }
        catch (ECPProjectWithNameExistsException ex) {
            Activator.log(ex);
        }
        return null;
    }

    private File getFile(Shell shell) {
        FileDialog dialog = new FileDialog(shell, 4096);
        dialog.setFilterNames(FILTER_NAMES);
        dialog.setFilterExtensions(FILTER_EXTS);
        String initialPath = PreferenceHelper.getPreference((String)EXPORT_MODEL_PATH, (String)System.getProperty("user.home"));
        dialog.setFilterPath(initialPath);
        String fileName = dialog.open();
        if (fileName == null) {
            return null;
        }
        File file = new File(dialog.getFilterPath(), dialog.getFileName());
        PreferenceHelper.setPreference((String)EXPORT_MODEL_PATH, (String)file.getParent());
        return file;
    }
}

