/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.explorereditorbridge.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.edit.spi.ECPControlContext;
import org.eclipse.emf.ecp.internal.edit.ECPControlHelper;
import org.eclipse.emf.ecp.internal.ui.Messages;
import org.eclipse.emf.ecp.internal.ui.util.ECPHandlerHelper;
import org.eclipse.emf.ecp.internal.ui.view.ViewProviderHelper;
import org.eclipse.emf.ecp.internal.wizards.SelectModelElementWizard;
import org.eclipse.emf.ecp.spi.core.InternalProject;
import org.eclipse.emf.ecp.ui.common.CompositeFactory;
import org.eclipse.emf.ecp.ui.common.CompositeProvider;
import org.eclipse.emf.ecp.ui.common.SelectionComposite;
import org.eclipse.emf.ecp.view.context.ViewModelContext;
import org.eclipse.emf.ecp.view.model.VElement;
import org.eclipse.emf.ecp.view.model.VView;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

public class ECPControlContextImpl
implements ECPControlContext {
    private final EObject modelElement;
    private final ECPProject ecpProject;
    private final Shell shell;
    private final EMFDataBindingContext dataBindingContext = new EMFDataBindingContext();

    public ECPControlContextImpl(EObject modelElement, ECPProject ecpProject, Shell shell) {
        this.modelElement = modelElement;
        this.ecpProject = ecpProject;
        this.shell = shell;
    }

    public ECPControlContextImpl(EObject modelElement, ECPProject ecpProject, Shell shell, ViewModelContext viewContext) {
        this.modelElement = modelElement;
        this.ecpProject = ecpProject;
        this.shell = shell;
    }

    public ECPControlContextImpl(EObject domainObject, ECPProject ecpProject, Shell shell, VElement view) {
        this.modelElement = domainObject;
        this.ecpProject = ecpProject;
        this.shell = shell;
    }

    public DataBindingContext getDataBindingContext() {
        return this.dataBindingContext;
    }

    public EditingDomain getEditingDomain() {
        if (this.ecpProject != null) {
            return this.ecpProject.getEditingDomain();
        }
        return AdapterFactoryEditingDomain.getEditingDomainFor((EObject)this.modelElement);
    }

    public void openInNewContext(EObject o) {
        ECPHandlerHelper.openModelElement((Object)o, (ECPProject)this.ecpProject);
    }

    public void addModelElement(EObject newMEInstance, EReference eReference) {
        if (eReference == null) {
            this.ecpProject.getContents().add((Object)newMEInstance);
        }
        if (eReference.isContainer()) {
            MessageDialog.openError((Shell)this.shell, (String)"Error", (String)"Operation not permitted for container references!");
            return;
        }
        ECPControlHelper.addModelElementInReference((EObject)this.modelElement, (EObject)newMEInstance, (EReference)eReference, (EditingDomain)this.getEditingDomain());
    }

    public EObject getModelElement() {
        return this.modelElement;
    }

    public EObject getNewElementFor(EReference eReference) {
        Collection classes = ECPUtil.getSubClasses((EClass)eReference.getEReferenceType());
        SelectModelElementWizard wizard = new SelectModelElementWizard("New Reference Element", Messages.NewModelElementWizard_WizardTitle_AddModelElement, Messages.NewModelElementWizard_PageTitle_AddModelElement, Messages.NewModelElementWizard_PageDescription_AddModelElement);
        SelectionComposite helper = CompositeFactory.getSelectModelClassComposite(new HashSet(), new HashSet(), (Collection)classes);
        wizard.setCompositeProvider((CompositeProvider)helper);
        WizardDialog wd = new WizardDialog(this.shell, (IWizard)wizard);
        EObject newMEInstance = null;
        int result = wd.open();
        if (result == 0) {
            Object[] selection = helper.getSelection();
            if (selection == null || selection.length == 0) {
                return null;
            }
            EClass eClasse = (EClass)selection[0];
            EPackage ePackage = eClasse.getEPackage();
            newMEInstance = ePackage.getEFactoryInstance().create(eClasse);
        }
        if (newMEInstance == null) {
            return null;
        }
        return newMEInstance;
    }

    public EObject getExistingElementFor(EReference eReference) {
        Iterator allElements = ((InternalProject)this.ecpProject).getReferenceCandidates(this.modelElement, eReference);
        HashSet<EObject> elements = new HashSet<EObject>();
        while (allElements.hasNext()) {
            elements.add((EObject)allElements.next());
        }
        SelectModelElementWizard wizard = new SelectModelElementWizard("Select Elements", Messages.NewModelElementWizard_WizardTitle_AddModelElement, Messages.ModelelementSelectionDialog_DialogTitle, Messages.ModelelementSelectionDialog_DialogMessage_SearchPattern, EObject.class);
        SelectionComposite tableSelectionComposite = CompositeFactory.getTableSelectionComposite((Object)elements.toArray());
        wizard.setCompositeProvider((CompositeProvider)tableSelectionComposite);
        WizardDialog wd = new WizardDialog(this.shell, (IWizard)wizard);
        EObject eObject = null;
        int result = wd.open();
        if (result == 0) {
            Object[] selection = tableSelectionComposite.getSelection();
            if (selection == null || selection.length == 0) {
                return null;
            }
            eObject = (EObject)selection[0];
        }
        return eObject;
    }

    public boolean isRunningAsWebApplication() {
        return false;
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public ECPControlContext createSubContext(EObject eObject) {
        return new ECPControlContextImpl(eObject, this.ecpProject, this.shell);
    }

    private VView getView() {
        return ViewProviderHelper.getView((EObject)this.getModelElement());
    }

    public ViewModelContext getViewContext() {
        return null;
    }
}

