/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.explorereditorbridge.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.core.util.observer.ECPObserver;
import org.eclipse.emf.ecp.core.util.observer.ECPProjectContentTouchedObserver;
import org.eclipse.emf.ecp.core.util.observer.ECPProjectOpenClosedObserver;
import org.eclipse.emf.ecp.core.util.observer.ECPProjectsChangedObserver;
import org.eclipse.emf.ecp.edit.spi.ECPContextDisposedListener;
import org.eclipse.emf.ecp.edit.spi.ECPEditorContext;
import org.eclipse.emf.ecp.explorereditorbridge.internal.ECPControlContextImpl;
import org.eclipse.emf.ecp.spi.core.InternalProject;
import org.eclipse.swt.widgets.Shell;

public class EditorContext
extends ECPControlContextImpl
implements ECPEditorContext {
    private final List<ECPContextDisposedListener> contextListeners = new ArrayList<ECPContextDisposedListener>();
    private final ECPProjectsChangedObserver projectObserver;
    private final ECPProject ecpProject;

    public EditorContext(EObject modelElement, ECPProject ecpProject, Shell shell) {
        super(modelElement, ecpProject, shell);
        this.ecpProject = ecpProject;
        this.projectObserver = new IECPProjectsChangedUIObserverImplementation();
        ECPUtil.getECPObserverBus().register((ECPObserver)this.projectObserver);
    }

    public void addECPContextDisposeListener(ECPContextDisposedListener modelElementContextListener) {
        this.contextListeners.add(modelElementContextListener);
    }

    public void dispose() {
        ECPUtil.getECPObserverBus().unregister((ECPObserver)this.projectObserver);
        this.contextListeners.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class IECPProjectsChangedUIObserverImplementation
    implements ECPProjectsChangedObserver,
    ECPProjectOpenClosedObserver,
    ECPProjectContentTouchedObserver {
        private IECPProjectsChangedUIObserverImplementation() {
        }

        public void projectsChanged(Collection<ECPProject> oldProjects, Collection<ECPProject> newProjects) {
            if (!newProjects.contains(EditorContext.this.ecpProject)) {
                for (ECPContextDisposedListener contextListener : EditorContext.this.contextListeners) {
                    contextListener.contextDisposed();
                }
                EditorContext.this.dispose();
            }
        }

        public void projectChanged(ECPProject project, boolean opened) {
            if (!opened) {
                for (ECPContextDisposedListener contextListener : EditorContext.this.contextListeners) {
                    contextListener.contextDisposed();
                }
                EditorContext.this.dispose();
            }
        }

        public void contentTouched(ECPProject project, Collection<Object> objects, boolean structural) {
            if (structural && EditorContext.this.ecpProject.equals(project) && !((InternalProject)project).contains((Object)EditorContext.this.getModelElement())) {
                for (ECPContextDisposedListener contextListener : EditorContext.this.contextListeners) {
                    contextListener.contextDisposed();
                }
                EditorContext.this.dispose();
            }
        }
    }
}

