/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ui.platform;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecp.ui.platform.Activator;
import org.osgi.service.prefs.BackingStoreException;

public final class PreferenceHelper {
    private static final String PREFERENCE_NODE = "ecp";

    private PreferenceHelper() {
    }

    public static String getPreference(String key, String defaultValue) {
        String value = Platform.getPreferencesService().getRootNode().node("configuration").node(PREFERENCE_NODE).get(key, defaultValue);
        return value;
    }

    public static void setPreference(String key, String value) {
        if (key != null && value != null) {
            Platform.getPreferencesService().getRootNode().node("configuration").node(PREFERENCE_NODE).put(key, value);
            try {
                Platform.getPreferencesService().getRootNode().node("configuration").node(PREFERENCE_NODE).flush();
            }
            catch (BackingStoreException e) {
                Activator.log("Could not persist the preference change: {" + key + ", " + value + "}", e);
            }
        }
    }
}

