/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.editor.handler;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.core.ECPProject;
import org.eclipse.emf.ecp.view.editor.controls.Helper;
import org.eclipse.emf.ecp.view.model.VContainer;
import org.eclipse.emf.ecp.view.model.VControl;
import org.eclipse.emf.ecp.view.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.model.VView;
import org.eclipse.emf.ecp.view.model.VViewFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlGenerator {
    public static void addControls(ECPProject project, VContainer compositeToFill, EClass datasegment, Set<EStructuralFeature> features) {
        EClass rootClass = Helper.getRootEClass(project);
        ControlGenerator.addControls(rootClass, compositeToFill, datasegment, features);
    }

    public static void addControls(EClass rootClass, VContainer compositeToFill, EClass datasegment, Set<EStructuralFeature> features) {
        HashMap<EClass, EReference> childParentReferenceMap = new HashMap<EClass, EReference>();
        Helper.getReferenceMap(rootClass, childParentReferenceMap);
        List<EReference> bottomUpPath = Helper.getReferencePath(datasegment, childParentReferenceMap);
        for (EStructuralFeature feature : features) {
            VControl control = VViewFactory.eINSTANCE.createControl();
            control.setName("Control " + feature.getName());
            control.setReadonly(false);
            VFeaturePathDomainModelReference modelReference = VViewFactory.eINSTANCE.createFeaturePathDomainModelReference();
            modelReference.setDomainModelEFeature(feature);
            modelReference.getDomainModelEReferencePath().addAll(bottomUpPath);
            control.setDomainModelReference((VDomainModelReference)modelReference);
            compositeToFill.getChildren().add((Object)control);
        }
    }

    public static void addControls(EClass rootClass, VView compositeToFill, EClass datasegment, Set<EStructuralFeature> features) {
        HashMap<EClass, EReference> childParentReferenceMap = new HashMap<EClass, EReference>();
        Helper.getReferenceMap(rootClass, childParentReferenceMap);
        List<EReference> bottomUpPath = Helper.getReferencePath(datasegment, childParentReferenceMap);
        for (EStructuralFeature feature : features) {
            VControl control = VViewFactory.eINSTANCE.createControl();
            control.setName("Control " + feature.getName());
            control.setReadonly(false);
            VFeaturePathDomainModelReference modelReference = VViewFactory.eINSTANCE.createFeaturePathDomainModelReference();
            modelReference.setDomainModelEFeature(feature);
            modelReference.getDomainModelEReferencePath().addAll(bottomUpPath);
            control.setDomainModelReference((VDomainModelReference)modelReference);
            compositeToFill.getChildren().add((Object)control);
        }
    }
}

