/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ui.view.swt.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.internal.swt.util.ECPControlSWT;
import org.eclipse.emf.ecp.edit.internal.swt.util.SWTRenderingHelper;
import org.eclipse.emf.ecp.edit.spi.ECPAbstractControl;
import org.eclipse.emf.ecp.edit.spi.ECPControl;
import org.eclipse.emf.ecp.edit.spi.ECPControlFactory;
import org.eclipse.emf.ecp.internal.ui.view.Activator;
import org.eclipse.emf.ecp.internal.ui.view.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.internal.ui.view.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.internal.ui.view.renderer.Node;
import org.eclipse.emf.ecp.internal.ui.view.renderer.RenderingResultRow;
import org.eclipse.emf.ecp.ui.view.swt.internal.AbstractSWTRenderer;
import org.eclipse.emf.ecp.view.model.LabelAlignment;
import org.eclipse.emf.ecp.view.model.VControl;
import org.eclipse.emf.ecp.view.model.VElement;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWTControlRenderer
extends AbstractSWTRenderer<VControl> {
    public static final SWTControlRenderer INSTANCE = new SWTControlRenderer();

    @Override
    public List<RenderingResultRow<Control>> renderSWT(Node<VControl> node, AdapterFactoryItemDelegator adapterFactoryItemDelegator, Object ... initData) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        VControl modelControl = (VControl)node.getRenderable();
        ECPControlFactory controlFactory = Activator.getDefault().getECPControlFactory();
        if (controlFactory == null) {
            Activator.getDefault().ungetECPControlFactory();
            return null;
        }
        ECPAbstractControl control = (ECPAbstractControl)controlFactory.createControl(ECPAbstractControl.class, modelControl.getDomainModelReference());
        if (control != null) {
            List createControls;
            control.init(node.getControlContext(), modelControl.getDomainModelReference());
            Composite parent = this.getParentFromInitData(initData);
            Label label = null;
            if (control.showLabel() && modelControl.getLabelAlignment() == LabelAlignment.LEFT) {
                EStructuralFeature.Setting setting = (EStructuralFeature.Setting)modelControl.getDomainModelReference().getIterator().next();
                IItemPropertyDescriptor itemPropertyDescriptor = adapterFactoryItemDelegator.getPropertyDescriptor((Object)setting.getEObject(), (Object)setting.getEStructuralFeature());
                if (itemPropertyDescriptor == null) {
                    throw new NoPropertyDescriptorFoundExeption(setting.getEObject(), setting.getEStructuralFeature());
                }
                label = new Label(parent, 0);
                label.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_label");
                label.setBackground(parent.getBackground());
                String extra = "";
                if (setting.getEStructuralFeature().getLowerBound() > 0) {
                    extra = "*";
                }
                label.setText(String.valueOf(itemPropertyDescriptor.getDisplayName((Object)setting.getEObject())) + extra);
                label.setToolTipText(itemPropertyDescriptor.getDescription((Object)setting.getEObject()));
            }
            if ((createControls = ((ECPControlSWT)control).createControls(parent)) == null) {
                return null;
            }
            control.setEditable(!modelControl.isReadonly());
            ArrayList<RenderingResultRow<Control>> result = new ArrayList<RenderingResultRow>();
            Control next = (Control)((RenderingResultRow)createControls.iterator().next()).getControls().iterator().next();
            if (label != null) {
                result.add(SWTRenderingHelper.INSTANCE.getResultRowFactory().createRenderingResultRow((Object[])new Control[]{label, next}));
            } else {
                result = createControls;
            }
            if (label == null) {
                node.addRenderingResultDelegator(this.withSWTControls((ECPControl)control, (VElement)modelControl, next));
            } else {
                node.addRenderingResultDelegator(this.withSWTControls((ECPControl)control, (VElement)modelControl, new Control[]{next, label}));
            }
            return result;
        }
        Activator.getDefault().ungetECPControlFactory();
        return null;
    }
}

