/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ui.view.swt.internal;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecp.edit.internal.swt.util.OverlayImageDescriptor;
import org.eclipse.emf.ecp.internal.ui.view.emf.AdapterFactoryLabelProvider;
import org.eclipse.emf.ecp.internal.ui.view.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.internal.ui.view.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.internal.ui.view.renderer.Node;
import org.eclipse.emf.ecp.internal.ui.view.renderer.RenderingResultDelegator;
import org.eclipse.emf.ecp.internal.ui.view.renderer.RenderingResultDelegatorAdapter;
import org.eclipse.emf.ecp.internal.ui.view.renderer.RenderingResultRow;
import org.eclipse.emf.ecp.ui.view.swt.internal.AbstractSWTRenderer;
import org.eclipse.emf.ecp.ui.view.swt.internal.Activator;
import org.eclipse.emf.ecp.ui.view.swt.internal.ECPTreeViewAction;
import org.eclipse.emf.ecp.ui.view.swt.internal.SWTRenderers;
import org.eclipse.emf.ecp.view.model.VAbstractCategorization;
import org.eclipse.emf.ecp.view.model.VCategory;
import org.eclipse.emf.ecp.view.model.VElement;
import org.eclipse.emf.ecp.view.model.VView;
import org.eclipse.emf.ecp.view.model.VViewPackage;
import org.eclipse.emf.ecp.view.model.impl.VControlImpl;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWTViewRenderer
extends AbstractSWTRenderer<VView> {
    public static final SWTViewRenderer INSTANCE = new SWTViewRenderer();
    private static ImageDescriptor errorDescriptor = Activator.getImageDescriptor("icons/error_decorate.png");
    private static ImageDescriptor warningDescriptor = Activator.getImageDescriptor("icons/warning_decorate.png");
    private final Set<Class<?>> filteredClasses = new LinkedHashSet<Class<?>>(){
        {
            this.add(VControlImpl.class);
        }
    };

    @Override
    public List<RenderingResultRow<Control>> renderSWT(Node<VView> viewNode, AdapterFactoryItemDelegator adapterFactoryItemDelegator, Object ... initData) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        Composite parent = this.getParentFromInitData(initData);
        final VView view = (VView)viewNode.getRenderable();
        final RefreshTreeViewerAdapter adapter = new RefreshTreeViewerAdapter();
        view.eAdapters().add((Object)adapter);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                view.eAdapters().remove((Object)adapter);
            }
        });
        EList categorizations = view.getCategorizations();
        if (categorizations.size() == 0) {
            return this.renderChildren(parent, viewNode, adapterFactoryItemDelegator);
        }
        if (categorizations.size() == 1 && categorizations.get(0) instanceof VCategory) {
            List<RenderingResultRow<Control>> resultRows = SWTRenderers.INSTANCE.render(parent, (Node)viewNode.getChildren().get(0), adapterFactoryItemDelegator);
            viewNode.addRenderingResultDelegator(this.withSWT((Control)resultRows.get(0).getMainControl()));
            return resultRows;
        }
        Composite composite = this.createComposite(parent);
        TreeViewer treeViewer = new TreeViewer(composite);
        ScrolledComposite editorComposite = this.createdEditorPane(composite);
        this.setupTreeViewer(treeViewer, adapterFactoryItemDelegator, viewNode, editorComposite);
        adapter.setTreeViewer(treeViewer);
        viewNode.addRenderingResultDelegator(this.withSWT((Control)composite));
        this.initTreeViewer(treeViewer, viewNode);
        return this.createResult(new Control[]{composite});
    }

    private List<RenderingResultRow<Control>> renderChildren(Composite parent, Node<VView> node, AdapterFactoryItemDelegator adapterFactoryItemDelegator) throws NoRendererFoundException {
        Composite columnComposite = new Composite(parent, 0);
        columnComposite.setBackground(parent.getBackground());
        columnComposite.setLayout((Layout)this.getLayoutHelper().getColumnLayout(2, false));
        node.addRenderingResultDelegator(this.withSWT((Control)columnComposite));
        for (Node child : node.getChildren()) {
            List<RenderingResultRow<Control>> resultRows;
            try {
                resultRows = SWTRenderers.INSTANCE.render(columnComposite, child, adapterFactoryItemDelegator);
            }
            catch (NoPropertyDescriptorFoundExeption noPropertyDescriptorFoundExeption) {
                continue;
            }
            if (resultRows == null) continue;
            this.setLayoutDataForResultRows(resultRows);
        }
        return this.createResult(new Control[]{columnComposite});
    }

    protected ScrolledComposite createdEditorPane(Composite composite) {
        ScrolledComposite editorComposite = this.createScrolledComposite(composite);
        editorComposite.setExpandHorizontal(true);
        editorComposite.setExpandVertical(true);
        editorComposite.setShowFocusedControl(true);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)editorComposite);
        return editorComposite;
    }

    protected List<Node<? extends VElement>> filterVisibleNodes(TreeViewer treeViewer, Node<? extends VElement> node) {
        ArrayList<Node<? extends VElement>> result = new ArrayList<Node<? extends VElement>>();
        List children = node.getChildren();
        for (Node child : children) {
            if (!child.isVisible()) continue;
            if (this.filteredClasses.contains(child.getLabelObject().getClass())) {
                result.addAll(this.filterVisibleNodes(treeViewer, (Node<? extends VElement>)child));
                continue;
            }
            result.add((Node<? extends VElement>)child);
        }
        return result;
    }

    private ScrolledComposite createScrolledComposite(Composite parent) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 2816);
        scrolledComposite.setShowFocusedControl(true);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setBackground(parent.getBackground());
        Composite childComposite = new Composite((Composite)scrolledComposite, 0);
        childComposite.setBackground(parent.getBackground());
        return scrolledComposite;
    }

    protected void setupTreeViewer(final TreeViewer treeViewer, AdapterFactoryItemDelegator adapterFactoryItemDelegator, final Node<VView> viewNode, final ScrolledComposite editorComposite) {
        GridDataFactory.fillDefaults().align(1, 4).grab(false, true).hint(400, -1).applyTo((Control)treeViewer.getTree());
        final ArrayList<TreeEditor> editors = new ArrayList<TreeEditor>();
        treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                Object[] children = this.getChildren(element);
                if (children == null) {
                    return false;
                }
                return children.length > 0;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public Object[] getChildren(Object parentElement) {
                Node node = (Node)parentElement;
                List<Node<? extends VElement>> visisbleNodes = SWTViewRenderer.this.filterVisibleNodes(treeViewer, (Node<? extends VElement>)node);
                return visisbleNodes.toArray();
            }
        });
        treeViewer.setLabelProvider((IBaseLabelProvider)new TreeTableLabelProvider(adapterFactoryItemDelegator.getAdapterFactory()));
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){
            private Node<?> lastSelection;

            public void selectionChanged(SelectionChangedEvent event) {
                block9: {
                    ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
                    AdapterFactoryItemDelegator newAdapterFactoryItemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)composedAdapterFactory);
                    try {
                        TreeSelection treeSelection = (TreeSelection)event.getSelection();
                        Object selection = treeSelection.getFirstElement();
                        SWTViewRenderer.this.addButtons(treeViewer, treeSelection, viewNode.getControlContext().getModelElement(), editors);
                        if (selection == null) {
                            return;
                        }
                        if (this.lastSelection != null) {
                            this.lastSelection.cleanup();
                        }
                        this.lastSelection = (Node)selection;
                        Composite childComposite = SWTViewRenderer.this.createComposite((Composite)editorComposite);
                        childComposite.setBackground(editorComposite.getBackground());
                        editorComposite.setContent((Control)childComposite);
                        if (!Node.class.isInstance(selection)) break block9;
                        Node node = (Node)selection;
                        try {
                            List<RenderingResultRow<Control>> resultRows = SWTRenderers.INSTANCE.render(childComposite, node, newAdapterFactoryItemDelegator);
                            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)resultRows.get(0).getMainControl());
                            viewNode.fireSelectedChildNodeChanged(node);
                        }
                        catch (NoRendererFoundException e) {
                            e.printStackTrace();
                        }
                        catch (NoPropertyDescriptorFoundExeption e) {
                            e.printStackTrace();
                        }
                        childComposite.layout();
                        Point point = childComposite.computeSize(-1, -1);
                        editorComposite.setMinSize(point);
                    }
                    finally {
                        composedAdapterFactory.dispose();
                    }
                }
            }
        });
        this.addTreeEditor(treeViewer, viewNode.getControlContext().getModelElement(), (VView)viewNode.getRenderable(), editors);
    }

    protected void initTreeViewer(final TreeViewer treeViewer, Node<VView> viewNode) {
        viewNode.addRenderingResultDelegator((RenderingResultDelegator)new RenderingResultDelegatorAdapter(){

            public void validationChanged(Map<EObject, Set<Diagnostic>> affectedObjects) {
                treeViewer.refresh();
            }
        });
        treeViewer.setInput(viewNode);
        treeViewer.expandAll();
        treeViewer.setSelection((ISelection)new StructuredSelection(viewNode.getChildren().get(0)));
    }

    private Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(composite);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).applyTo((Control)composite);
        return composite;
    }

    protected void addTreeEditor(TreeViewer treeViewer, EObject modelElement, VView view, final List<TreeEditor> editors) {
        Tree tree = treeViewer.getTree();
        TreeColumn columnText = new TreeColumn(tree, 0);
        columnText.setWidth(300);
        columnText.setAlignment(4);
        int maxActions = 0;
        TreeIterator viewContents = view.eAllContents();
        while (viewContents.hasNext()) {
            VAbstractCategorization abstractCategorization;
            EObject object = (EObject)viewContents.next();
            if (!VAbstractCategorization.class.isInstance(object) || maxActions >= (abstractCategorization = (VAbstractCategorization)object).getActions().size()) continue;
            maxActions = abstractCategorization.getActions().size();
        }
        int i = 0;
        while (i < maxActions) {
            TreeColumn column = new TreeColumn(tree, 0);
            column.setWidth(50);
            TreeEditor editor = new TreeEditor(tree);
            editor.horizontalAlignment = 0x1000000;
            editor.grabHorizontal = true;
            editor.minimumWidth = 50;
            editor.setColumn(i + 1);
            editors.add(editor);
            ++i;
        }
        tree.addTreeListener(new TreeListener(){

            public void treeExpanded(TreeEvent e) {
            }

            public void treeCollapsed(TreeEvent e) {
                SWTViewRenderer.this.cleanUpTreeEditors(editors);
            }
        });
    }

    private void cleanUpTreeEditors(List<TreeEditor> editors) {
        for (TreeEditor editor : editors) {
            Control oldEditor = editor.getEditor();
            if (oldEditor == null) continue;
            oldEditor.dispose();
        }
    }

    protected void addButtons(TreeViewer treeViewer, TreeSelection treeSelection, EObject modelElement, List<TreeEditor> editors) {
        this.cleanUpTreeEditors(editors);
        if (treeSelection.getPaths().length == 0) {
            return;
        }
        TreeItem item = treeViewer.getTree().getSelection()[0];
        if (item == null) {
            return;
        }
        Node object = (Node)treeSelection.getFirstElement();
        if (object.getActions() == null) {
            return;
        }
        int i = 0;
        while (i < object.getActions().size()) {
            ECPTreeViewAction action = (ECPTreeViewAction)object.getActions().get(i);
            TreeEditor editor = editors.get(i);
            action.init(treeViewer, treeSelection, editor, modelElement);
            action.execute();
            ++i;
        }
    }

    private class RefreshTreeViewerAdapter
    extends EContentAdapter {
        private TreeViewer treeViewer;

        private RefreshTreeViewerAdapter() {
        }

        public void setTreeViewer(TreeViewer treeViewer) {
            this.treeViewer = treeViewer;
        }

        public void notifyChanged(Notification msg) {
            super.notifyChanged(msg);
            if (this.treeViewer == null) {
                return;
            }
            if (VAbstractCategorization.class.isInstance(msg.getNotifier()) && VViewPackage.eINSTANCE.getElement_Diagnostic().equals(msg.getFeature()) && msg.getEventType() == 1) {
                this.treeViewer.refresh();
            }
        }
    }

    protected class TreeTableLabelProvider
    extends AdapterFactoryLabelProvider
    implements ITableItemLabelProvider {
        public TreeTableLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Image getColumnImage(Object object, int columnIndex) {
            if (columnIndex != 0) {
                return null;
            }
            Image image = super.getColumnImage(object, columnIndex);
            if (!Node.class.isInstance(object)) {
                return image;
            }
            Node node = (Node)object;
            image = super.getImage(node.getLabelObject());
            ImageDescriptor overlay = null;
            switch (node.getSeverity()) {
                case 4: {
                    overlay = errorDescriptor;
                    break;
                }
                case 2: {
                    overlay = warningDescriptor;
                    break;
                }
            }
            if (overlay == null) {
                return image;
            }
            OverlayImageDescriptor imageDescriptor = new OverlayImageDescriptor(image, overlay, 2);
            Image resultImage = imageDescriptor.createImage();
            return resultImage;
        }

        public String getColumnText(Object object, int columnIndex) {
            if (columnIndex != 0) {
                return "";
            }
            Node node = (Node)object;
            return super.getText(node.getLabelObject());
        }
    }
}

