/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ui.view.renderer;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecp.internal.ui.view.Activator;
import org.eclipse.emf.ecp.internal.ui.view.RendererContext;
import org.eclipse.emf.ecp.internal.ui.view.renderer.ControlRenderer;
import org.eclipse.emf.ecp.internal.ui.view.renderer.ModelRenderer;
import org.eclipse.emf.ecp.internal.ui.view.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.internal.ui.view.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.internal.ui.view.renderer.Node;
import org.eclipse.emf.ecp.internal.ui.view.renderer.RenderingResultRow;
import org.eclipse.emf.ecp.view.model.VElement;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelRendererImpl<C>
implements ModelRenderer<C> {
    @Override
    public <R extends VElement> RendererContext<C> render(Node<R> node, Object ... initData) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        ControlRenderer<R, C> renderer = this.getControlRenderer();
        if (renderer == null) {
            throw new IllegalStateException("Renderer not initialized!");
        }
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        AdapterFactoryItemDelegator adapterFactoryItemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)composedAdapterFactory);
        RendererContext<C> rendererContext = new RendererContext<C>(node, node.getControlContext());
        List<RenderingResultRow<C>> rowResults = renderer.render(node, adapterFactoryItemDelegator, initData);
        rendererContext.setRenderedResult(rowResults.get(0).getMainControl());
        composedAdapterFactory.dispose();
        return rendererContext;
    }

    private <R extends VElement> ControlRenderer<R, C> getControlRenderer() {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.emf.ecp.ui.view.renderer");
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement configurationElement = extension.getConfigurationElements()[0];
            try {
                ControlRenderer renderer = (ControlRenderer)configurationElement.createExecutableExtension("class");
                return renderer;
            }
            catch (CoreException ex) {
                Activator.log((Exception)((Object)ex));
                ++n2;
            }
        }
        return null;
    }
}

