/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ui.view.renderer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.edit.spi.ECPControlContext;
import org.eclipse.emf.ecp.internal.ui.view.ECPAction;
import org.eclipse.emf.ecp.internal.ui.view.RendererContext;
import org.eclipse.emf.ecp.internal.ui.view.renderer.RenderingResultDelegator;
import org.eclipse.emf.ecp.internal.ui.view.renderer.SelectedChildNodeListener;
import org.eclipse.emf.ecp.view.context.ModelChangeNotification;
import org.eclipse.emf.ecp.view.context.ViewModelContext;
import org.eclipse.emf.ecp.view.model.VElement;
import org.eclipse.emf.ecp.view.model.VViewPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node<T extends VElement>
implements RendererContext.ValidationListener,
ViewModelContext.ModelChangeListener {
    protected List<RenderingResultDelegator> delegators;
    protected int severity;
    private final T viewModelElement;
    private final List<Node<?>> children;
    private final ECPControlContext controlContext;
    private Object labelObject;
    private List<ECPAction> actions;
    private final List<SelectedChildNodeListener> selectedChildNodeListeners;

    public Node(T model, ECPControlContext controlContext) {
        this.viewModelElement = model;
        this.labelObject = model;
        this.controlContext = controlContext;
        this.children = new ArrayList();
        this.delegators = new ArrayList<RenderingResultDelegator>();
        this.selectedChildNodeListeners = new ArrayList<SelectedChildNodeListener>();
    }

    public T getRenderable() {
        return this.viewModelElement;
    }

    public void addChild(Node<? extends VElement> node) {
        if (node == null) {
            throw new IllegalArgumentException("Invalid child node: null");
        }
        this.children.add(node);
    }

    public List<Node<?>> getChildren() {
        return this.children;
    }

    public void enable(boolean isEnabled) {
        if (this.viewModelElement.isReadonly()) {
            return;
        }
        for (Node<?> child : this.getChildren()) {
            child.enable(isEnabled);
        }
        for (RenderingResultDelegator delegator : this.delegators) {
            delegator.enable(isEnabled);
        }
    }

    public void show(boolean isVisible) {
        for (Node<?> child : this.getChildren()) {
            child.show(isVisible);
        }
        for (RenderingResultDelegator delegator : this.delegators) {
            delegator.show(isVisible);
        }
    }

    public void layout() {
        for (RenderingResultDelegator delegator : this.delegators) {
            delegator.layout();
        }
    }

    public void cleanup() {
        for (RenderingResultDelegator renderingResultDelegator : this.delegators) {
            renderingResultDelegator.cleanup();
        }
        this.delegators.clear();
        for (Node node : this.getChildren()) {
            node.cleanup();
        }
    }

    @Override
    public void validationChanged(Map<EObject, Set<Diagnostic>> affectedObjects) {
        this.severity = this.calculateSeverity(affectedObjects);
    }

    protected int calculateSeverity(Map<EObject, Set<Diagnostic>> affectedObjects) {
        int max = 0;
        if (affectedObjects.containsKey(this.viewModelElement)) {
            for (Diagnostic diagnostic : affectedObjects.get(this.viewModelElement)) {
                if (this.viewModelElement != this.labelObject && !diagnostic.getData().get(0).equals(this.labelObject) || diagnostic.getSeverity() <= max) continue;
                max = diagnostic.getSeverity();
            }
        }
        return max;
    }

    public boolean isLeaf() {
        return false;
    }

    public void dispose() {
        for (Node<?> child : this.getChildren()) {
            child.dispose();
        }
        this.children.clear();
        this.cleanup();
        this.selectedChildNodeListeners.clear();
    }

    public void addRenderingResultDelegator(RenderingResultDelegator delegator) {
        this.delegators.add(delegator);
        delegator.show(this.viewModelElement.isVisible());
        if (!this.viewModelElement.isReadonly()) {
            delegator.enable(this.viewModelElement.isEnabled());
        }
    }

    public void removeRenderingResultDelegator(RenderingResultDelegator delegator) {
        this.delegators.remove(delegator);
    }

    public boolean isVisible() {
        return this.viewModelElement.isVisible();
    }

    public boolean isEnabled() {
        return this.viewModelElement.isEnabled();
    }

    public ECPControlContext getControlContext() {
        return this.controlContext;
    }

    public Object getLabelObject() {
        return this.labelObject;
    }

    public void setLabelObject(Object object) {
        this.labelObject = object;
    }

    public List<ECPAction> getActions() {
        return this.actions;
    }

    public void setActions(List<ECPAction> actions) {
        this.actions = actions;
    }

    public boolean isLifted() {
        return !this.delegators.isEmpty();
    }

    public int getSeverity() {
        return this.viewModelElement.getDiagnostic().getHighestSeverity();
    }

    public void addSelectedChildNodeListener(SelectedChildNodeListener listener) {
        this.selectedChildNodeListeners.add(listener);
    }

    public void removeSelectedChildNodeListener(SelectedChildNodeListener listener) {
        this.selectedChildNodeListeners.add(listener);
    }

    public void fireSelectedChildNodeChanged(Node<?> selectedChild) {
        for (SelectedChildNodeListener listener : this.selectedChildNodeListeners) {
            listener.childSelected(selectedChild);
        }
    }

    public void notifyChange(ModelChangeNotification notification) {
        if (notification.getNotifier() == this.viewModelElement) {
            if (notification.getStructuralFeature() == VViewPackage.eINSTANCE.getElement_Enabled()) {
                this.enable(this.viewModelElement.isEnabled());
            }
            if (notification.getStructuralFeature() == VViewPackage.eINSTANCE.getElement_Visible()) {
                this.show(this.viewModelElement.isVisible());
            }
        } else {
            for (Node<?> child : this.getChildren()) {
                child.notifyChange(notification);
            }
        }
    }

    public void notifyAdd(Notifier notifier) {
    }

    public void notifyRemove(Notifier notifier) {
    }
}

