/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.ui;

import java.util.Collection;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecp.core.ECPProvider;
import org.eclipse.emf.ecp.core.util.ECPCheckoutSource;
import org.eclipse.emf.ecp.core.util.ECPContainer;
import org.eclipse.emf.ecp.core.util.ECPProperties;
import org.eclipse.emf.ecp.core.util.ECPProviderAware;
import org.eclipse.emf.ecp.core.util.observer.ECPObserver;
import org.eclipse.emf.ecp.internal.core.util.ElementRegistry;
import org.eclipse.emf.ecp.internal.core.util.ExtensionParser;
import org.eclipse.emf.ecp.spi.core.InternalProvider;
import org.eclipse.emf.ecp.spi.core.util.AdapterProvider;
import org.eclipse.emf.ecp.spi.ui.CompositeStateObserver;
import org.eclipse.emf.ecp.spi.ui.DefaultUIProvider;
import org.eclipse.emf.ecp.spi.ui.UIProvider;
import org.eclipse.emf.ecp.spi.ui.UIProviderRegistry;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UIProviderRegistryImpl
extends ElementRegistry<UIProvider, ECPObserver>
implements UIProviderRegistry {
    public static final UIProviderRegistryImpl INSTANCE = new UIProviderRegistryImpl();
    private final UIProviderParser extensionParser = new UIProviderParser();

    private UIProviderRegistryImpl() {
    }

    @Override
    public UIProvider getUIProvider(Object adaptable) {
        ECPProvider provider;
        if (adaptable instanceof ECPProviderAware && (provider = ((ECPProviderAware)adaptable).getProvider()) != null) {
            return this.getUIProvider(provider);
        }
        return (UIProvider)AdapterUtil.adapt((Object)adaptable, UIProvider.class);
    }

    private synchronized UIProvider getUIProvider(ECPProvider provider) {
        UIProvider uiProvider = (UIProvider)((InternalProvider)provider).getUIProvider();
        if (uiProvider != null) {
            return uiProvider;
        }
        for (UIProvider ui : this.getUIProviders()) {
            if (!ui.getProvider().equals(provider)) continue;
            uiProvider = ui;
            break;
        }
        if (uiProvider == null) {
            uiProvider = new DefaultUIProvider(String.valueOf(provider.getName()) + ".default");
        }
        ((InternalProvider)provider).setUIProvider((AdapterProvider)uiProvider);
        return uiProvider;
    }

    @Override
    public UIProvider getUIProvider(String name) {
        return (UIProvider)this.getElement(name);
    }

    @Override
    public Collection<UIProvider> getUIProviders() {
        return this.getElements();
    }

    @Override
    public boolean hasUIProviders() {
        return this.hasElements();
    }

    protected void notifyObservers(Collection<UIProvider> oldElements, Collection<UIProvider> newElements) throws Exception {
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.extensionParser.activate();
    }

    protected void doDeactivate() throws Exception {
        this.extensionParser.deactivate();
        super.doDeactivate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class UIProviderDescriptor
    extends ExtensionParser.ExtensionDescriptor<UIProvider>
    implements UIProvider {
        public UIProviderDescriptor(String name, IConfigurationElement configurationElement) {
            super((ElementRegistry)UIProviderRegistryImpl.this, name, "UIProvider", configurationElement);
        }

        @Override
        public InternalProvider getProvider() {
            return ((UIProvider)this.getResolvedElement()).getProvider();
        }

        public <T> T getAdapter(Object adaptable, Class<T> adapterType) {
            return (T)((UIProvider)this.getResolvedElement()).getAdapter(adaptable, adapterType);
        }

        public Object getAdapter(Class adapterType) {
            return ((UIProvider)this.getResolvedElement()).getAdapter(adapterType);
        }

        @Override
        public String getText(Object element) {
            return ((UIProvider)this.getResolvedElement()).getText(element);
        }

        @Override
        public Image getImage(Object element) {
            return ((UIProvider)this.getResolvedElement()).getImage(element);
        }

        @Override
        public void fillContextMenu(IMenuManager manager, ECPContainer context, Object[] elements) {
            ((UIProvider)this.getResolvedElement()).fillContextMenu(manager, context, elements);
        }

        @Override
        public Control createAddRepositoryUI(Composite parent, ECPProperties repositoryProperties, Text repositoryNameText, Text repositoryLabelText, Text repositoryDescriptionText) {
            return ((UIProvider)this.getResolvedElement()).createAddRepositoryUI(parent, repositoryProperties, repositoryNameText, repositoryLabelText, repositoryDescriptionText);
        }

        @Override
        public Control createCheckoutUI(Composite parent, ECPCheckoutSource checkoutSource, ECPProperties projectProperties) {
            return ((UIProvider)this.getResolvedElement()).createCheckoutUI(parent, checkoutSource, projectProperties);
        }

        @Override
        public Control createNewProjectUI(Composite parent, CompositeStateObserver observer, ECPProperties projectProperties) {
            return ((UIProvider)this.getResolvedElement()).createNewProjectUI(parent, observer, projectProperties);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class UIProviderParser
    extends ExtensionParser<UIProvider> {
        private static final String EXTENSION_POINT_NAME = "uiProviders";

        public UIProviderParser() {
            super((ElementRegistry)UIProviderRegistryImpl.this, "org.eclipse.emf.ecp.ui", EXTENSION_POINT_NAME);
        }

        protected UIProvider createElement(String name, IConfigurationElement configurationElement) {
            UIProviderDescriptor descriptor = new UIProviderDescriptor(name, configurationElement);
            descriptor.setLabel(configurationElement.getDeclaringExtension().getLabel());
            descriptor.setDescription(configurationElement.getAttribute("description"));
            return descriptor;
        }
    }
}

