/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ui.view.custom.swt;

import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.internal.swt.util.DoubleColumnRow;
import org.eclipse.emf.ecp.edit.internal.swt.util.ECPControlSWT;
import org.eclipse.emf.ecp.edit.internal.swt.util.ECPDialogExecutor;
import org.eclipse.emf.ecp.edit.internal.swt.util.SWTControl;
import org.eclipse.emf.ecp.edit.internal.swt.util.SingleColumnRow;
import org.eclipse.emf.ecp.edit.spi.ECPControl;
import org.eclipse.emf.ecp.internal.ui.view.renderer.RenderingResultRow;
import org.eclipse.emf.ecp.ui.view.custom.ECPAbstractCustomControl;
import org.eclipse.emf.ecp.view.custom.ui.internal.swt.Activator;
import org.eclipse.emf.ecp.view.model.VDomainModelReference;
import org.eclipse.jface.databinding.viewers.ViewerSupport;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ECPAbstractCustomControlSWT
extends ECPAbstractCustomControl
implements ECPControlSWT {
    public static final int VALIDATION_ERROR_IMAGE = 0;
    public static final int ADD_IMAGE = 1;
    public static final int DELETE_IMAGE = 2;
    public static final int HELP_IMAGE = 3;
    private final SWTCustomControlHelper swtHelper = new SWTCustomControlHelper();
    private Label validationLabel;
    private Shell shell;
    private List<RenderingResultRow<Control>> renderingResult;

    public ECPAbstractCustomControlSWT(Set<VDomainModelReference> features) {
        super(features);
    }

    protected final void createValidationLabel(Composite parent) {
        this.validationLabel = new Label(parent, 0);
        this.validationLabel.setBackground(parent.getBackground());
        this.validationLabel.setImage(this.getImage(0));
        this.validationLabel.setVisible(false);
    }

    protected final void showError(String title, String message) {
        this.showMessageDialog(1, title, message);
    }

    protected final void showInfo(String title, String message) {
        this.showMessageDialog(2, title, message);
    }

    public final void setMessageShell(Shell shell) {
        this.shell = shell;
    }

    private void showMessageDialog(int type, String title, String message) {
        MessageDialog dialog = new MessageDialog(this.shell, title, null, message, type, new String[]{JFaceResources.getString((String)"ok")}, 0);
        new ECPDialogExecutor((Dialog)dialog){

            public void handleResult(int codeResult) {
            }
        }.execute();
    }

    public final List<RenderingResultRow<Control>> createControls(Composite composite) {
        this.renderingResult = this.createControl(composite);
        return this.renderingResult;
    }

    protected abstract List<RenderingResultRow<Control>> createControl(Composite var1);

    public void setEditable(boolean isEditable) {
        for (RenderingResultRow<Control> row : this.renderingResult) {
            if (SingleColumnRow.class.isInstance(row)) {
                ((SingleColumnRow)row).getControl().setEnabled(false);
                continue;
            }
            if (!DoubleColumnRow.class.isInstance(row)) continue;
            ((DoubleColumnRow)row).getLeftControl().setEnabled(false);
            ((DoubleColumnRow)row).getRightControl().setEnabled(false);
        }
    }

    public final void handleValidation(Diagnostic diagnostic) {
        if (diagnostic.getSeverity() == 4 || diagnostic.getSeverity() == 2) {
            Diagnostic reason = diagnostic;
            if (diagnostic.getChildren() != null && diagnostic.getChildren().size() != 0) {
                reason = (Diagnostic)diagnostic.getChildren().get(0);
            }
            if (this.validationLabel != null) {
                this.validationLabel.setVisible(true);
                this.validationLabel.setToolTipText(reason.getMessage());
            }
            List data = diagnostic.getData();
            this.handleCreatedControls(diagnostic);
            this.handleContentValidation(diagnostic.getSeverity(), data.size() > 1 && EStructuralFeature.class.isInstance(data.get(1)) ? data.get(1) : null);
        } else {
            this.resetValidation();
        }
    }

    private void handleCreatedControls(Diagnostic diagnostic) {
        if (diagnostic.getData().size() < 2) {
            return;
        }
        if (!(diagnostic.getData().get(1) instanceof EStructuralFeature)) {
            return;
        }
        EStructuralFeature feature = (EStructuralFeature)diagnostic.getData().get(1);
        ECPControl ecpControl = this.getRetrievedControl(feature);
        if (ecpControl == null) {
            return;
        }
        ecpControl.handleValidation(diagnostic);
    }

    protected abstract void handleContentValidation(int var1, EStructuralFeature var2);

    public final void resetValidation() {
        this.resetControlValidation();
        if (this.validationLabel != null) {
            this.validationLabel.setVisible(false);
        }
        this.resetContentValidation();
    }

    protected abstract void resetContentValidation();

    protected final SWTCustomControlHelper getSWTHelper() {
        return this.swtHelper;
    }

    private Image getImage(int imageType) {
        switch (imageType) {
            case 0: {
                return Activator.getImage("icons/validation_error.png");
            }
            case 3: {
                return Activator.getImage("icons/help.png");
            }
            case 1: {
                return Activator.getImage("icons/add.png");
            }
            case 2: {
                return Activator.getImage("icons/delete.png");
            }
        }
        return null;
    }

    protected final Composite createControl(VDomainModelReference domainModelReference, Composite parent) {
        SWTControl control = (SWTControl)this.getControl(SWTControl.class, domainModelReference);
        control.init(this.getModelElementContext(), domainModelReference);
        return control.createControl(parent);
    }

    public final void dispose() {
        if (this.validationLabel != null) {
            this.validationLabel.dispose();
            this.validationLabel = null;
        }
        super.dispose();
    }

    protected void createViewerBinding(VDomainModelReference customControlFeature, StructuredViewer viewer, IValueProperty[] labelProperties) {
        IObservableList list = this.getObservableList(customControlFeature);
        ViewerSupport.bind((StructuredViewer)viewer, (IObservableList)list, (IValueProperty[])labelProperties);
    }

    public final class SWTCustomControlHelper {
        public Image getImage(int imageType) {
            return ECPAbstractCustomControlSWT.this.getImage(imageType);
        }
    }
}

