/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.groupedgrid.ui.swt.internal;

import java.util.List;
import org.eclipse.emf.ecp.edit.groupedgrid.model.VGroup;
import org.eclipse.emf.ecp.edit.groupedgrid.model.VGroupedGrid;
import org.eclipse.emf.ecp.edit.groupedgrid.model.VRow;
import org.eclipse.emf.ecp.edit.groupedgrid.model.VSpan;
import org.eclipse.emf.ecp.internal.ui.view.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.internal.ui.view.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.internal.ui.view.renderer.Node;
import org.eclipse.emf.ecp.internal.ui.view.renderer.RenderingResultRow;
import org.eclipse.emf.ecp.ui.view.swt.internal.AbstractSWTRenderer;
import org.eclipse.emf.ecp.ui.view.swt.internal.SWTRenderers;
import org.eclipse.emf.ecp.view.model.LabelAlignment;
import org.eclipse.emf.ecp.view.model.VAttachment;
import org.eclipse.emf.ecp.view.model.VContainedElement;
import org.eclipse.emf.ecp.view.model.VControl;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupedGridSWTRenderer
extends AbstractSWTRenderer<VGroupedGrid> {
    public static final GroupedGridSWTRenderer INSTANCE = new GroupedGridSWTRenderer();

    public List<RenderingResultRow<Control>> renderSWT(Node<VGroupedGrid> node, AdapterFactoryItemDelegator adapterFactoryItemDelegator, Object ... initData) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        Composite parent = this.getParentFromInitData(initData);
        Composite columnComposite = new Composite(parent, 0);
        columnComposite.setBackground(parent.getBackground());
        node.addRenderingResultDelegator(this.withSWT((Control)columnComposite));
        int maxNumColumns = this.calculateColumns((VGroupedGrid)node.getRenderable());
        GridLayoutFactory.fillDefaults().numColumns(maxNumColumns).equalWidth(true).applyTo(columnComposite);
        List children = node.getChildren();
        int currentControl = 0;
        for (VGroup group : ((VGroupedGrid)node.getRenderable()).getGroups()) {
            Composite labelComposite = new Composite(columnComposite, 0);
            labelComposite.setBackground(parent.getBackground());
            GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(labelComposite);
            GridDataFactory.fillDefaults().grab(true, false).align(4, 1).span(maxNumColumns, 1).applyTo((Control)labelComposite);
            Label l = new Label(labelComposite, 0);
            l.setText(group.getName());
            l.setBackground(parent.getBackground());
            GridDataFactory.fillDefaults().grab(false, false).align(1, 1).applyTo((Control)l);
            Label seperator = new Label(labelComposite, 258);
            GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)seperator);
            for (VRow row : group.getRows()) {
                int spanned = 0;
                for (VContainedElement child : row.getChildren()) {
                    VControl control;
                    Node childNode = (Node)children.get(currentControl++);
                    int hSpan = this.getHSpanOfComposite(child);
                    List resultRows = SWTRenderers.INSTANCE.render(columnComposite, childNode, adapterFactoryItemDelegator);
                    if (resultRows == null) continue;
                    Control childRender = (Control)((RenderingResultRow)resultRows.get(0)).getMainControl();
                    childRender.setBackground(parent.getBackground());
                    GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).indent(0, 0).span(hSpan, 1).applyTo(childRender);
                    GridDataFactory.createFrom((GridData)((GridData)childRender.getLayoutData())).indent(10, 0).applyTo(childRender);
                    spanned += hSpan;
                    if (!childNode.isLeaf() || !VControl.class.isInstance(childNode.getRenderable()) || (control = (VControl)childNode.getRenderable()).getLabelAlignment() != LabelAlignment.LEFT) continue;
                    ++spanned;
                }
                int spanDif = maxNumColumns - spanned;
                if (spanDif == 0) continue;
                Label filler = new Label(columnComposite, 0);
                filler.setBackground(parent.getBackground());
                GridDataFactory.fillDefaults().span(spanDif, 1).applyTo((Control)filler);
            }
        }
        return this.createResult(new Control[]{columnComposite});
    }

    private int calculateColumns(VGroupedGrid renderable) {
        int maxColumns = 0;
        for (VGroup group : renderable.getGroups()) {
            for (VRow row : group.getRows()) {
                int columns = 0;
                for (VContainedElement composite : row.getChildren()) {
                    columns += this.getHSpanOfComposite(composite) + this.getExtraColumnForLabel(composite);
                }
                if (columns <= maxColumns) continue;
                maxColumns = columns;
            }
        }
        return maxColumns;
    }

    private int getHSpanOfComposite(VContainedElement composite) {
        for (VAttachment attachment : composite.getAttachments()) {
            if (!VSpan.class.isInstance(attachment)) continue;
            VSpan span = (VSpan)attachment;
            return span.getHorizontalSpan();
        }
        return 1;
    }

    private int getExtraColumnForLabel(VContainedElement child) {
        if (VControl.class.isInstance(child)) {
            VControl control = (VControl)child;
            return control.getLabelAlignment() == LabelAlignment.LEFT ? 1 : 0;
        }
        return 0;
    }
}

