/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.model.generator;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.internal.ui.view.IViewProvider;
import org.eclipse.emf.ecp.view.model.VControl;
import org.eclipse.emf.ecp.view.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.model.VView;
import org.eclipse.emf.ecp.view.model.VViewFactory;

public class ViewProvider
implements IViewProvider {
    public VView generate(EObject eObject) {
        VView view = VViewFactory.eINSTANCE.createView();
        for (EStructuralFeature feature : eObject.eClass().getEAllStructuralFeatures()) {
            if (this.isInvalidFeature(feature)) continue;
            VControl control = VViewFactory.eINSTANCE.createControl();
            VFeaturePathDomainModelReference modelReference = VViewFactory.eINSTANCE.createFeaturePathDomainModelReference();
            modelReference.setDomainModelEFeature(feature);
            control.setDomainModelReference((VDomainModelReference)modelReference);
            view.getChildren().add((Object)control);
        }
        return view;
    }

    private boolean isInvalidFeature(EStructuralFeature feature) {
        return this.isContainerReference(feature) || this.isTransient(feature) || this.isVolatile(feature);
    }

    private boolean isContainerReference(EStructuralFeature feature) {
        EReference reference;
        return feature instanceof EReference && (reference = (EReference)feature).isContainer();
    }

    private boolean isTransient(EStructuralFeature feature) {
        return feature.isTransient();
    }

    private boolean isVolatile(EStructuralFeature feature) {
        return feature.isVolatile();
    }

    public int canRender(EObject eObject) {
        return 1;
    }
}

