/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.rule;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.BidirectionalMap;
import org.eclipse.emf.ecp.view.internal.rule.AllEAttributes;
import org.eclipse.emf.ecp.view.model.VElement;
import org.eclipse.emf.ecp.view.rule.model.AndCondition;
import org.eclipse.emf.ecp.view.rule.model.Condition;
import org.eclipse.emf.ecp.view.rule.model.LeafCondition;
import org.eclipse.emf.ecp.view.rule.model.OrCondition;
import org.eclipse.emf.ecp.view.rule.model.Rule;
import org.eclipse.emf.ecp.view.rule.model.impl.LeafConditionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleRegistry<T extends Rule> {
    private static NoCondition noCondition = new NoCondition();
    private final Map<EStructuralFeature, BidirectionalMap<LeafCondition, T>> featuresToRules = new LinkedHashMap<EStructuralFeature, BidirectionalMap<LeafCondition, T>>();
    private final BidirectionalMap<T, VElement> rulesToRenderables = new BidirectionalMap();

    public void register(VElement renderable, T rule, Condition condition, EObject domainModel) {
        if (condition == null) {
            this.mapFeatureToRule((EStructuralFeature)AllEAttributes.get(), (LeafCondition)noCondition, rule);
            this.rulesToRenderables.put(rule, (Object)renderable);
        } else if (condition instanceof LeafCondition) {
            LeafCondition leafCondition = (LeafCondition)condition;
            leafCondition.getDomainModelReference().resolve(domainModel);
            Iterator featureIterator = leafCondition.getDomainModelReference().getEStructuralFeatureIterator();
            while (featureIterator.hasNext()) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)featureIterator.next();
                this.mapFeatureToRule(eStructuralFeature, leafCondition, rule);
            }
            this.rulesToRenderables.put(rule, (Object)renderable);
        } else if (condition instanceof OrCondition) {
            OrCondition orCondition = (OrCondition)condition;
            for (Condition cond : orCondition.getConditions()) {
                this.register(renderable, rule, cond, domainModel);
            }
        } else {
            AndCondition andCondition = (AndCondition)condition;
            for (Condition cond : andCondition.getConditions()) {
                this.register(renderable, rule, cond, domainModel);
            }
        }
    }

    public VElement removeRule(T rule) {
        Condition condition = rule.getCondition();
        if (condition != null) {
            return this.removeCondition(condition);
        }
        Collection<BidirectionalMap<LeafCondition, T>> values = this.featuresToRules.values();
        for (BidirectionalMap<LeafCondition, T> bidirectionalMap : values) {
            if (bidirectionalMap.removeByValue(rule) != null) break;
        }
        VElement renderable = (VElement)this.rulesToRenderables.getValue(rule);
        this.rulesToRenderables.removeByKey(rule);
        return renderable;
    }

    public void removeRenderable(VElement renderable) {
        this.rulesToRenderables.removeByValue((Object)renderable);
    }

    public VElement removeCondition(Condition condition) {
        LeafCondition leafCondition;
        Iterator settingIterator;
        EStructuralFeature.Setting setting;
        BidirectionalMap<LeafCondition, T> bidirectionalMap;
        VElement ret = null;
        if (LeafCondition.class.isInstance(condition) && (bidirectionalMap = this.featuresToRules.get((setting = (EStructuralFeature.Setting)(settingIterator = (leafCondition = (LeafCondition)LeafCondition.class.cast(condition)).getDomainModelReference().getIterator()).next()).getEStructuralFeature())) != null) {
            Rule removeByKey = (Rule)bidirectionalMap.removeByKey((Object)leafCondition);
            ret = (VElement)this.rulesToRenderables.removeByKey((Object)removeByKey);
        }
        return ret;
    }

    private void mapFeatureToRule(EStructuralFeature attribute, LeafCondition condition, T rule) {
        if (!this.featuresToRules.containsKey(attribute)) {
            this.featuresToRules.put(attribute, new BidirectionalMap());
        }
        this.featuresToRules.get(attribute).put((Object)condition, rule);
    }

    public Set<EStructuralFeature> getAttributes() {
        return this.featuresToRules.keySet();
    }

    public Map<T, VElement> getAffectedRenderables(EStructuralFeature feature) {
        LinkedHashMap<Rule, VElement> result = new LinkedHashMap<Rule, VElement>();
        BidirectionalMap<LeafCondition, T> bidirectionalMap = this.featuresToRules.get(feature);
        if (bidirectionalMap == null) {
            bidirectionalMap = this.featuresToRules.get((Object)AllEAttributes.get());
        }
        if (bidirectionalMap == null) {
            return Collections.emptyMap();
        }
        for (Rule rule : bidirectionalMap.values()) {
            VElement renderable = (VElement)this.rulesToRenderables.getValue((Object)rule);
            result.put(rule, renderable);
        }
        return result;
    }

    static class NoCondition
    extends LeafConditionImpl {
        NoCondition() {
        }
    }
}

