/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.table.ui.swt;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.edit.internal.swt.controls.TableControl;
import org.eclipse.emf.ecp.edit.internal.swt.table.TableColumnConfiguration;
import org.eclipse.emf.ecp.edit.internal.swt.table.TableControlConfiguration;
import org.eclipse.emf.ecp.edit.spi.ECPControl;
import org.eclipse.emf.ecp.edit.spi.ECPControlContext;
import org.eclipse.emf.ecp.internal.ui.view.Activator;
import org.eclipse.emf.ecp.internal.ui.view.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.internal.ui.view.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.internal.ui.view.renderer.Node;
import org.eclipse.emf.ecp.internal.ui.view.renderer.RenderingResultRow;
import org.eclipse.emf.ecp.ui.view.swt.internal.AbstractSWTRenderer;
import org.eclipse.emf.ecp.view.model.VElement;
import org.eclipse.emf.ecp.view.table.model.VTableColumn;
import org.eclipse.emf.ecp.view.table.model.VTableControl;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWTTableControlRenderer
extends AbstractSWTRenderer<VTableControl> {
    public static final SWTTableControlRenderer INSTANCE = new SWTTableControlRenderer();

    public List<RenderingResultRow<Control>> renderSWT(Node<VTableControl> node, AdapterFactoryItemDelegator adapterFactoryItemDelegator, Object ... initData) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        VTableControl modelTableControl = (VTableControl)node.getRenderable();
        ECPControlContext subContext = node.getControlContext();
        Iterator settings = modelTableControl.getDomainModelReference().getIterator();
        if (!settings.hasNext()) {
            return null;
        }
        EStructuralFeature.Setting setting = (EStructuralFeature.Setting)settings.next();
        if (setting.getEStructuralFeature() == null) {
            return null;
        }
        EClass dataClass = setting.getEStructuralFeature().getEContainingClass();
        if (dataClass == null) {
            return null;
        }
        IItemPropertyDescriptor itemPropertyDescriptor = adapterFactoryItemDelegator.getPropertyDescriptor((Object)setting.getEObject(), (Object)setting.getEStructuralFeature());
        if (itemPropertyDescriptor == null) {
            return null;
        }
        TableControlConfiguration tcc = new TableControlConfiguration();
        tcc.setAddRemoveDisabled(modelTableControl.isAddRemoveDisabled());
        for (VTableColumn column : modelTableControl.getColumns()) {
            tcc.getColumns().add(new TableColumnConfiguration(column.isReadOnly(), column.getAttribute()));
        }
        TableControl control = new TableControl();
        control.setTableControlConfiguration(tcc);
        control.init(subContext, modelTableControl.getDomainModelReference());
        Composite parent = this.getParentFromInitData(initData);
        Label label = null;
        if (control.showLabel()) {
            label = new Label(parent, 0);
            label.setData("org.eclipse.rap.rwt.customVariant", (Object)"org_eclipse_emf_ecp_control_label");
            label.setBackground(parent.getBackground());
            String extra = "";
            if (((EStructuralFeature)itemPropertyDescriptor.getFeature(null)).getLowerBound() > 0) {
                extra = "*";
            }
            label.setText(String.valueOf(itemPropertyDescriptor.getDisplayName((Object)subContext.getModelElement())) + extra);
            label.setToolTipText(itemPropertyDescriptor.getDescription((Object)subContext.getModelElement()));
        }
        Composite controlComposite = control.createControl(parent);
        controlComposite.setBackground(parent.getBackground());
        control.setEditable(!modelTableControl.isReadonly());
        if (label == null) {
            node.addRenderingResultDelegator(this.withSWTControls((ECPControl)control, (VElement)modelTableControl, new Control[]{controlComposite}));
        } else {
            node.addRenderingResultDelegator(this.withSWTControls((ECPControl)control, (VElement)modelTableControl, new Control[]{controlComposite, label}));
        }
        if (label == null) {
            return this.createResult(new Control[]{controlComposite});
        }
        Activator.getDefault().ungetECPControlFactory();
        return this.createResult(new Control[]{label, controlComposite});
    }
}

