/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.table.ui;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.model.VControl;
import org.eclipse.emf.ecp.view.model.VElement;
import org.eclipse.emf.ecp.view.table.model.VTableControl;
import org.eclipse.emf.ecp.view.validation.ECPValidationSubProcessor;
import org.eclipse.emf.ecp.view.validation.ValidationRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableControlSubProcessor
implements ECPValidationSubProcessor {
    public Map<EObject, Set<VControl>> processRenderable(EObject domainObject, VElement parentRenderable, final ValidationRegistry validationRegistry) {
        final VTableControl tableControl = (VTableControl)parentRenderable;
        LinkedHashMap<EObject, Set<VControl>> result = new LinkedHashMap<EObject, Set<VControl>>();
        Iterator settings = tableControl.getDomainModelReference().getIterator();
        if (!settings.hasNext()) {
            return result;
        }
        final EStructuralFeature.Setting setting = (EStructuralFeature.Setting)settings.next();
        EObject referencedDomainModel = setting.getEObject();
        if (referencedDomainModel == null) {
            return result;
        }
        final EList tableContent = (EList)referencedDomainModel.eGet(setting.getEStructuralFeature());
        if (!validationRegistry.getRenderablesForEObject(domainObject).contains(parentRenderable)) {
            referencedDomainModel.eAdapters().add(0, (Object)new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.isTouch()) {
                        return;
                    }
                    if (msg.getFeature() != setting.getEStructuralFeature()) {
                        return;
                    }
                    for (EObject tableChild : tableContent) {
                        validationRegistry.addEObjectControlMapping(tableChild, (VControl)tableControl);
                    }
                }
            });
        }
        this.addControlToMap(tableControl, result, referencedDomainModel);
        for (EObject eObject : tableContent) {
            this.addControlToMap(tableControl, result, eObject);
        }
        return result;
    }

    private void addControlToMap(VTableControl tableControl, Map<EObject, Set<VControl>> result, EObject referencedDomainModel) {
        if (!result.containsKey(referencedDomainModel)) {
            result.put(referencedDomainModel, new LinkedHashSet());
        }
        result.get(referencedDomainModel).add((VControl)tableControl);
    }
}

