/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.validation;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.common.UniqueSetting;
import org.eclipse.emf.ecp.view.validation.ViewModelGraphNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SettingsNodeMapping<T> {
    private static final EStructuralFeature ALL_FEATURES = null;
    private final Map<UniqueSetting, ViewModelGraphNode<T>> settings = new LinkedHashMap<UniqueSetting, ViewModelGraphNode<T>>();
    private final Comparator<T> comparator;

    public SettingsNodeMapping(Comparator<T> comparator) {
        this.comparator = comparator;
    }

    public ViewModelGraphNode<T> getNode(EObject eObject, EStructuralFeature feature) {
        UniqueSetting setting = UniqueSetting.createSetting((EObject)eObject, (EStructuralFeature)feature);
        ViewModelGraphNode<T> node = this.settings.get(setting);
        if (node == null) {
            return null;
        }
        return node;
    }

    public ViewModelGraphNode<T> createNode(EObject eObject, EStructuralFeature feature, T value, boolean isDomainObject) {
        UniqueSetting setting = UniqueSetting.createSetting((EObject)eObject, (EStructuralFeature)feature);
        ViewModelGraphNode<T> node = this.settings.get(setting);
        if (node == null) {
            node = this.createNode(setting, value, isDomainObject);
            this.settings.put(setting, node);
        } else {
            node.setValue(value);
        }
        return node;
    }

    private ViewModelGraphNode<T> createNode(UniqueSetting setting, T initValue, boolean isDomainObject) {
        return new ViewModelGraphNode<T>(setting, initValue, isDomainObject, this.comparator);
    }

    public void removeAll(EObject eObject) {
        EList eAllStructuralFeatures = eObject.eClass().getEAllStructuralFeatures();
        for (EStructuralFeature eStructuralFeature : eAllStructuralFeatures) {
            UniqueSetting setting = UniqueSetting.createSetting((EObject)eObject, (EStructuralFeature)eStructuralFeature);
            this.settings.remove(setting);
        }
        UniqueSetting setting = UniqueSetting.createSetting((EObject)eObject, (EStructuralFeature)ALL_FEATURES);
        this.settings.remove(setting);
    }

    public static EStructuralFeature allFeatures() {
        return ALL_FEATURES;
    }
}

