/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.validation;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.view.model.VControl;
import org.eclipse.emf.ecp.view.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.model.VElement;
import org.eclipse.emf.ecp.view.model.VViewFactory;
import org.eclipse.emf.ecp.view.validation.Activator;
import org.eclipse.emf.ecp.view.validation.ECPValidationSubProcessor;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationRegistry {
    private final Map<EObject, Set<VControl>> domainObjectToAffectedControls;
    private final Map<Class<VElement>, ECPValidationSubProcessor> subProcessors;
    private final Set<VElement> processedRenderables = new LinkedHashSet<VElement>();
    private Map<VElement, Set<EObject>> controlToDomainMapping = new LinkedHashMap<VElement, Set<EObject>>();

    public ValidationRegistry() {
        this.domainObjectToAffectedControls = new LinkedHashMap<EObject, Set<VControl>>();
        this.subProcessors = new LinkedHashMap<Class<VElement>, ECPValidationSubProcessor>();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        if (extensionRegistry == null) {
            return;
        }
        IConfigurationElement[] config = extensionRegistry.getConfigurationElementsFor("org.eclipse.emf.ecp.view.validation.validationSubProcessor");
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                ECPValidationSubProcessor o = (ECPValidationSubProcessor)e.createExecutableExtension("class");
                String associatedRenderable = e.getAttribute("associatedRenderable");
                Class supportedClassType = ValidationRegistry.loadClass(e.getContributor().getName(), associatedRenderable);
                this.subProcessors.put(supportedClassType, o);
                ++n2;
            }
        }
        catch (CoreException ex) {
            Activator.logException((Exception)((Object)ex));
        }
        catch (InvalidRegistryObjectException ex) {
            Activator.logException((Exception)((Object)ex));
        }
        catch (ClassNotFoundException ex) {
            Activator.logException(ex);
        }
    }

    private static <T> Class<T> loadClass(String bundleName, String clazz) throws ClassNotFoundException {
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            throw new ClassNotFoundException(String.valueOf(clazz) + "cannot be loaded" + bundleName + "cannot be resolved");
        }
        return bundle.loadClass(clazz);
    }

    public void register(EObject domainModel, VElement renderable) {
        Map<EObject, Set<VControl>> domainToControlMapping = this.getDomainToControlMapping(domainModel, renderable);
        this.fillMap(domainToControlMapping, this.domainObjectToAffectedControls);
    }

    public Map<EObject, Set<VControl>> getDomainToControlMapping(EObject domainModel, VElement renderable) {
        this.processedRenderables.add(renderable);
        if (renderable.getDiagnostic() == null) {
            renderable.setDiagnostic(VViewFactory.eINSTANCE.createDiagnostic());
        }
        LinkedHashMap<EObject, Set<VControl>> result = new LinkedHashMap<EObject, Set<VControl>>();
        Class<?> renderableClass = renderable.getClass().getInterfaces()[0];
        if (this.subProcessors.containsKey(renderableClass)) {
            this.fillMap(this.subProcessors.get(renderableClass).processRenderable(domainModel, renderable, this), result);
        } else if (VControl.class.isInstance(renderable)) {
            VControl control = (VControl)renderable;
            VDomainModelReference domainModelReference = control.getDomainModelReference();
            Iterator iterator = domainModelReference.getIterator();
            while (iterator.hasNext()) {
                EStructuralFeature.Setting setting = (EStructuralFeature.Setting)iterator.next();
                EObject referencedDomainModel = setting.getEObject();
                if (!result.containsKey(referencedDomainModel)) {
                    result.put(referencedDomainModel, new LinkedHashSet());
                }
                ((Set)result.get(referencedDomainModel)).add(control);
            }
        } else {
            for (EObject eObject : renderable.eContents()) {
                if (!VElement.class.isInstance(eObject)) continue;
                this.fillMap(this.getDomainToControlMapping(domainModel, (VElement)eObject), result);
            }
        }
        return result;
    }

    public EObject resolveDomainModel(EObject domainModel, List<EReference> references) {
        EObject referencedDomainModel = domainModel;
        for (EReference eReference : references) {
            if (!eReference.getEContainingClass().isInstance((Object)referencedDomainModel)) continue;
            EObject child = (EObject)referencedDomainModel.eGet((EStructuralFeature)eReference);
            if (child == null) {
                child = EcoreUtil.create((EClass)eReference.getEReferenceType());
                referencedDomainModel.eSet((EStructuralFeature)eReference, (Object)child);
            }
            referencedDomainModel = child;
        }
        return referencedDomainModel;
    }

    private void fillMap(Map<EObject, Set<VControl>> source, Map<EObject, Set<VControl>> target) {
        for (EObject domainSource : source.keySet()) {
            Set<VControl> controlSet = source.get(domainSource);
            this.fillMapEntry(target, domainSource, controlSet);
        }
    }

    private void fillMapEntry(Map<EObject, Set<VControl>> target, EObject domainSource, Set<VControl> controlSet) {
        for (VControl abstractControl : controlSet) {
            Set<EObject> set = this.controlToDomainMapping.get(abstractControl);
            if (set == null) {
                this.controlToDomainMapping.put((VElement)abstractControl, new LinkedHashSet());
            }
            this.controlToDomainMapping.get(abstractControl).add(domainSource);
        }
        if (!target.containsKey(domainSource)) {
            target.put(domainSource, controlSet);
        } else {
            target.get(domainSource).addAll(controlSet);
        }
    }

    public void addEObjectControlMapping(EObject domainObject, VControl control) {
        LinkedHashSet<VControl> controlSet = new LinkedHashSet<VControl>();
        controlSet.add(control);
        this.fillMapEntry(this.domainObjectToAffectedControls, domainObject, controlSet);
    }

    public void removeRenderable(VElement renderable) {
        Set<EObject> eObjects = this.controlToDomainMapping.get(renderable);
        if (eObjects != null) {
            for (EObject eObject : eObjects) {
                Set<VControl> set = this.domainObjectToAffectedControls.get(eObject);
                if (set == null || !set.contains(renderable)) continue;
                this.domainObjectToAffectedControls.get(eObject).remove(renderable);
            }
        }
        this.controlToDomainMapping.remove(renderable);
        this.processedRenderables.remove(renderable);
    }

    public void removeDomainObject(EObject domainObject) {
        Set<VControl> set = this.domainObjectToAffectedControls.get(domainObject);
        if (set != null) {
            for (VControl abstractControl : set) {
                this.controlToDomainMapping.remove(abstractControl);
            }
        }
        this.domainObjectToAffectedControls.remove(domainObject);
    }

    public Set<VControl> getRenderablesForEObject(EObject model) {
        if (!this.domainObjectToAffectedControls.containsKey(model)) {
            return Collections.emptySet();
        }
        return this.domainObjectToAffectedControls.get(model);
    }

    public boolean containsRenderable(VElement renderable) {
        return this.processedRenderables.contains(renderable);
    }
}

