/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.validation;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.model.VElement;
import org.eclipse.emf.ecp.view.validation.SettingsNodeMapping;
import org.eclipse.emf.ecp.view.validation.ViewModelGraphNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ViewModelGraph<T> {
    private final SettingsNodeMapping<T> viewModelSettings;
    private final SettingsNodeMapping<T> domainModelSettings;
    private final EObject domainModel;

    public ViewModelGraph(VElement viewModel, EObject domainModel, Comparator<T> comparator) {
        this.domainModel = domainModel;
        this.viewModelSettings = new SettingsNodeMapping<T>(comparator);
        this.domainModelSettings = new SettingsNodeMapping<T>(comparator);
        this.buildRenderableNodes((EObject)viewModel);
    }

    private void buildRenderableNodes(EObject viewModel) {
        EList eContents = viewModel.eContents();
        ViewModelGraphNode<T> parentNode = this.viewModelSettings.createNode(viewModel, SettingsNodeMapping.allFeatures(), this.getDefaultValue(), false);
        for (EObject content : eContents) {
            if (!VElement.class.isInstance(content)) continue;
            ViewModelGraphNode<T> childNode = this.viewModelSettings.createNode(content, SettingsNodeMapping.allFeatures(), this.getDefaultValue(), false);
            parentNode.addChild(childNode);
            this.buildRenderableNodes(content);
        }
    }

    public abstract T getDefaultValue();

    public T getValue(VElement renderable) {
        return this.viewModelSettings.getNode((EObject)renderable, SettingsNodeMapping.allFeatures()).getValue();
    }

    public void update(VElement renderable, EObject domainObject, EStructuralFeature feature, T value) {
        Set<ViewModelGraphNode<T>> parentNodes = this.updateNodes(renderable, domainObject, feature, value);
        for (ViewModelGraphNode<T> cachedNode : parentNodes) {
            this.updateParentNodes(cachedNode);
        }
    }

    private Set<EObject> updateParentNodes(ViewModelGraphNode<T> node) {
        LinkedHashSet<EObject> updated = new LinkedHashSet<EObject>();
        Set<ViewModelGraphNode<T>> nodes = node.getParents();
        this.updateRenderable((VElement)node.getSetting().getEObject());
        for (ViewModelGraphNode<T> cachedNode : nodes) {
            updated.addAll(this.updateParentNodes(cachedNode));
        }
        return updated;
    }

    public void removeDomainObject(EObject domainObject) {
        EList eAllStructuralFeatures = domainObject.eClass().getEAllStructuralFeatures();
        for (EStructuralFeature eStructuralFeature : eAllStructuralFeatures) {
            ViewModelGraphNode<T> node = this.domainModelSettings.getNode(domainObject, eStructuralFeature);
            if (node == null) continue;
            Set<ViewModelGraphNode<T>> parents = node.getParents();
            for (ViewModelGraphNode viewModelGraphNode : new LinkedHashSet<ViewModelGraphNode<T>>(parents)) {
                viewModelGraphNode.removeChild(node);
            }
        }
        this.domainModelSettings.removeAll(domainObject);
    }

    public void removeRenderable(VElement renderable) {
        ViewModelGraphNode<T> node = this.viewModelSettings.getNode((EObject)renderable, SettingsNodeMapping.allFeatures());
        if (node != null) {
            Set<ViewModelGraphNode<T>> parents = node.getParents();
            for (ViewModelGraphNode viewModelGraphNode : new LinkedHashSet<ViewModelGraphNode<T>>(parents)) {
                viewModelGraphNode.removeChild(node);
                this.updateParentNodes(viewModelGraphNode);
            }
            Iterator<ViewModelGraphNode<T>> iterator = node.getChildren();
            while (iterator.hasNext()) {
                node.removeChild(iterator.next());
            }
        }
        this.viewModelSettings.removeAll((EObject)renderable);
    }

    protected void updateRenderable(VElement renderable) {
    }

    private Set<ViewModelGraphNode<T>> updateNodes(VElement renderable, EObject domainObject, EStructuralFeature feature, T value) {
        LinkedHashSet<ViewModelGraphNode<T>> affectedParentNodes = new LinkedHashSet<ViewModelGraphNode<T>>();
        ViewModelGraphNode<T> renderableNode = this.getNodeForRenderable(renderable);
        ViewModelGraphNode<T> domainNode = this.getNodeForDomainObject(domainObject, feature, value);
        affectedParentNodes.add(renderableNode);
        if (this.domainObjectHasBeenRemoved(domainObject, feature)) {
            this.removeChildFromParents(domainNode);
            return affectedParentNodes;
        }
        if (!renderableNode.containsChild(domainNode)) {
            renderableNode.addChild(domainNode);
        }
        domainNode.setValue(value);
        return affectedParentNodes;
    }

    private ViewModelGraphNode<T> getNodeForDomainObject(EObject domainObject, EStructuralFeature feature, T value) {
        ViewModelGraphNode<T> node = this.domainModelSettings.getNode(domainObject, feature);
        if (node == null) {
            node = this.domainModelSettings.createNode(domainObject, feature, value, true);
        }
        return node;
    }

    private void removeChildFromParents(ViewModelGraphNode<T> childNode) {
        LinkedHashSet<ViewModelGraphNode<T>> parentNodes = new LinkedHashSet<ViewModelGraphNode<T>>(childNode.getParents());
        for (ViewModelGraphNode viewModelGraphNode : parentNodes) {
            viewModelGraphNode.removeChild(childNode);
        }
    }

    private boolean domainObjectHasBeenRemoved(EObject domainObject, EStructuralFeature feature) {
        ViewModelGraphNode<T> node = this.domainModelSettings.getNode(domainObject, feature);
        return node.isDomainObject() && !this.isDomainModelElement(domainObject);
    }

    private ViewModelGraphNode<T> getNodeForRenderable(VElement renderable) {
        ViewModelGraphNode<T> node = this.viewModelSettings.getNode((EObject)renderable, SettingsNodeMapping.allFeatures());
        if (node == null) {
            node = this.viewModelSettings.createNode((EObject)renderable, SettingsNodeMapping.allFeatures(), this.getDefaultValue(), false);
            EObject eContainer = renderable.eContainer();
            ViewModelGraphNode<T> possibleParent = this.viewModelSettings.getNode(eContainer, SettingsNodeMapping.allFeatures());
            if (possibleParent == null) {
                possibleParent = this.getNodeForRenderable((VElement)eContainer);
            }
            possibleParent.addChild(node);
        }
        return node;
    }

    private boolean isDomainModelElement(EObject possibleChild) {
        return this.isContainedInModel(this.domainModel, possibleChild);
    }

    private boolean isContainedInModel(EObject root, EObject possibleChild) {
        if (root == possibleChild) {
            return true;
        }
        EObject container = possibleChild;
        while (container != null) {
            if (container == root) {
                return true;
            }
            container = container.eContainer();
        }
        return false;
    }
}

