/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.validation;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.view.model.VControl;
import org.eclipse.emf.ecp.view.model.VDiagnostic;
import org.eclipse.emf.ecp.view.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.model.VElement;
import org.eclipse.emf.ecp.view.model.VViewFactory;
import org.eclipse.emf.ecp.view.validation.VDiagnosticHelper;
import org.eclipse.emf.ecp.view.validation.ValidationRegistry;
import org.eclipse.emf.ecp.view.validation.ViewModelGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewValidator
extends ViewModelGraph<VDiagnostic> {
    private final ValidationRegistry validationRegistry;

    public ViewValidator(VElement viewModel, EObject domainModel, ValidationRegistry validationRegistry) {
        super(viewModel, domainModel, new Comparator<VDiagnostic>(){

            @Override
            public int compare(VDiagnostic vDiagnostic1, VDiagnostic vDiagnostic2) {
                if (vDiagnostic1.getHighestSeverity() > vDiagnostic2.getHighestSeverity()) {
                    return 1;
                }
                if (vDiagnostic1.getHighestSeverity() == vDiagnostic2.getHighestSeverity()) {
                    return 0;
                }
                return -1;
            }
        });
        this.validationRegistry = validationRegistry;
    }

    @Override
    public VDiagnostic getDefaultValue() {
        VDiagnostic result = VViewFactory.eINSTANCE.createDiagnostic();
        result.getDiagnostics().add((Object)Diagnostic.OK_INSTANCE);
        return result;
    }

    public void validate(EObject eObject) {
        Diagnostic diagnostic = this.getDiagnosticForEObject(eObject);
        if (diagnostic.getSeverity() == 0) {
            for (VControl control : this.validationRegistry.getRenderablesForEObject(eObject)) {
                VDomainModelReference modelReference = control.getDomainModelReference();
                Iterator settings = modelReference.getIterator();
                while (settings.hasNext()) {
                    EStructuralFeature.Setting setting = (EStructuralFeature.Setting)settings.next();
                    if (!setting.getEStructuralFeature().getEContainingClass().equals(eObject.eClass())) continue;
                    this.update((VElement)control, eObject, setting.getEStructuralFeature(), this.getDefaultValue());
                }
            }
        } else {
            LinkedHashMap<EStructuralFeature, Diagnostic> featureToValidationResult = new LinkedHashMap<EStructuralFeature, Diagnostic>();
            for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                if (childDiagnostic.getData().size() != 2) continue;
                EStructuralFeature feature = (EStructuralFeature)childDiagnostic.getData().get(1);
                featureToValidationResult.put(feature, childDiagnostic);
            }
            for (EStructuralFeature invalidFeature : featureToValidationResult.keySet()) {
                for (VControl control : this.validationRegistry.getRenderablesForEObject(eObject)) {
                    VDomainModelReference modelReference = control.getDomainModelReference();
                    Iterator settings = modelReference.getIterator();
                    while (settings.hasNext()) {
                        EStructuralFeature.Setting setting = (EStructuralFeature.Setting)settings.next();
                        VDiagnostic vDiagnostic = VViewFactory.eINSTANCE.createDiagnostic();
                        if (setting.getEStructuralFeature().equals(invalidFeature)) {
                            vDiagnostic.getDiagnostics().add(featureToValidationResult.get(invalidFeature));
                            this.update((VElement)control, eObject, setting.getEStructuralFeature(), vDiagnostic);
                            continue;
                        }
                        if (!featureToValidationResult.containsKey(setting.getEStructuralFeature())) {
                            this.update((VElement)control, eObject, setting.getEStructuralFeature(), vDiagnostic);
                            continue;
                        }
                        if (featureToValidationResult.containsKey(setting.getEStructuralFeature()) || !eObject.eClass().getEAllStructuralFeatures().contains((Object)setting.getEStructuralFeature())) continue;
                        this.update((VElement)control, eObject, setting.getEStructuralFeature(), this.getDefaultValue());
                    }
                }
            }
        }
    }

    public void validate(Collection<EObject> eObjects) {
        for (EObject eObject : eObjects) {
            this.validate(eObject);
        }
    }

    @Override
    protected void updateRenderable(VElement renderable) {
        VDiagnostic val = (VDiagnostic)this.getValue(renderable);
        if (!VDiagnosticHelper.isEqual(renderable.getDiagnostic(), val)) {
            renderable.setDiagnostic((VDiagnostic)EcoreUtil.copy((EObject)val));
        }
    }

    public Diagnostic getDiagnosticForEObject(EObject object) {
        EValidator validator = EValidator.Registry.INSTANCE.getEValidator(object.eClass().getEPackage());
        BasicDiagnostic diagnostics = Diagnostician.INSTANCE.createDefaultDiagnostic(object);
        if (validator == null) {
            validator = new EObjectValidator();
        }
        LinkedHashMap<Class, Object> context = new LinkedHashMap<Class, Object>();
        context.put(EValidator.SubstitutionLabelProvider.class, Diagnostician.INSTANCE);
        context.put(EValidator.class, validator);
        validator.validate(object, (DiagnosticChain)diagnostics, context);
        return diagnostics;
    }
}

